/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.effect;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.inter.MoveFilterInterface;

public class AlbumGrayFilter
extends BasicFilter
implements MoveFilterInterface {
    public static final String UNIFORM_SHIFTX = "shiftX";
    public static final String UNIFORM_SHIFTY = "shiftY";
    public static final String UNIFORM_SHIFTW = "shiftW";
    public static final String UNIFORM_SHIFTH = "shiftH";
    public static final String UNIFORM_SHIFT = "shift";
    public static final String UNIFORM_JUDGE = "judge";
    public static final String UNIFORM_OFFSET = "offset";
    private int shiftXHandler;
    private int shiftYHandler;
    private int shiftWHandler;
    private int shiftHHandler;
    private int shiftHandler;
    private int judgeHandler;
    private int offsetHandler;
    private float offsetX = 0.0f;
    private float offsetY = 0.0f;
    private float offsetW = 0.0f;
    private float offsetH = 0.0f;
    private float offset = 1.0f;
    private float mJudge = 0.0f;
    private float mOffset = 1.0f;
    private boolean mHasChanged = true;
    private int mFrameRate = 15;
    private int mCount = 0;
    private String scanLine = "    float scanLineNumber = floor(uv.y*340.0);\n    float scanLineBrightness = 0.8*sin(fract(uv.y*340.0)*3.14159265358979323);    gl_FragColor = texture2D(inputImageTexture0,uv)*scanLineBrightness;\n";

    @Override
    protected String getFragmentShader() {
        String string = "precision highp float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform float shiftX;\nuniform float shiftY;\nuniform float shiftW;\nuniform float shiftH;\nuniform float shift;\nuniform float judge;\nuniform float offset;\nvec2 scaleFromCenter(vec2 coord, float scale) {\n  if (scale < 0.0) { return coord; }\n  vec2 scaleCenter = vec2(0.5);\n  return (coord - scaleCenter) * scale + scaleCenter;\n}\nvoid main(){\n    vec2 uv = textureCoordinate;\n    if (judge == 1.0) {\n    uv = scaleFromCenter(uv,offset);\n    if (uv.x > shift) {       gl_FragColor = texture2D(inputImageTexture0,uv);\n    } else {\n" + this.scanLine + "    }\n" + "    } else {\n" + "    if (uv.x < " + UNIFORM_SHIFT + ") {" + "       if (uv.x >= " + UNIFORM_SHIFTX + " - " + UNIFORM_SHIFTW + "/2.0 && uv.x <= " + UNIFORM_SHIFTX + " + " + UNIFORM_SHIFTW + "/2.0 && " + "uv.y > " + UNIFORM_SHIFTY + " - " + UNIFORM_SHIFTH + "/2.0  && uv.y < " + UNIFORM_SHIFTY + " + " + UNIFORM_SHIFTH + "/2.0 ) {\n" + this.scanLine + "       } else {\n" + "       uv = scaleFromCenter(uv," + UNIFORM_OFFSET + ");\n" + "       gl_FragColor = texture2D(" + "inputImageTexture0" + ",uv);\n" + "       }" + "    } else {\n" + "       uv = scaleFromCenter(uv," + UNIFORM_OFFSET + ");\n" + this.scanLine + "    }\n" + "  }\n" + "}\n";
        return string;
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.shiftXHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_SHIFTX);
        this.shiftYHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_SHIFTY);
        this.shiftWHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_SHIFTW);
        this.shiftHHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_SHIFTH);
        this.shiftHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_SHIFT);
        this.judgeHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_JUDGE);
        this.offsetHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_OFFSET);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        if (this.mHasChanged) {
            if (this.mCount <= 10) {
                this.offset = 0.6f;
                this.offsetX = (float)Math.random() * 0.6f;
                this.offsetY = (float)Math.random();
                this.offsetW = (float)Math.random() * 0.2f;
                this.offsetH = (float)Math.random() * 0.5f;
            } else if (10 < this.mCount && this.mCount <= 12) {
                this.offset = 0.6f;
                this.offsetX = 0.0f;
                this.offsetY = 0.0f;
                this.offsetW = 0.0f;
                this.offsetH = 0.0f;
                this.mOffset -= 0.005f;
            } else if (12 < this.mCount && this.mCount <= 25) {
                this.mJudge = 1.0f;
                this.mOffset -= 0.005f;
                if ((double)this.mOffset <= 0.8) {
                    this.mOffset = 0.8f;
                }
            } else {
                this.offset = 0.0f;
                this.mHasChanged = false;
            }
        }
        GLES20.glUniform1f((int)this.shiftXHandler, (float)this.offsetX);
        GLES20.glUniform1f((int)this.shiftYHandler, (float)this.offsetY);
        GLES20.glUniform1f((int)this.shiftWHandler, (float)this.offsetW);
        GLES20.glUniform1f((int)this.shiftHHandler, (float)this.offsetH);
        GLES20.glUniform1f((int)this.shiftHandler, (float)this.offset);
        GLES20.glUniform1f((int)this.judgeHandler, (float)this.mJudge);
        GLES20.glUniform1f((int)this.offsetHandler, (float)this.mOffset);
        ++this.mCount;
    }

    @Override
    public void textureChanged(boolean hasChanged) {
        this.mHasChanged = hasChanged;
        this.mCount = 0;
        this.mJudge = 0.0f;
        this.offset = 1.0f;
        this.mOffset = 1.0f;
    }

    public synchronized void startAnimation() {
        this.mHasChanged = true;
        this.mCount = 0;
        this.mJudge = 0.0f;
        this.offset = 1.0f;
        this.mOffset = 1.0f;
    }

    @Override
    public void setFrameRate(int rate) {
        this.mFrameRate = rate;
    }
}

