/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.colour;

import android.graphics.Point;
import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import project.android.imageprocessing.filter.MultiInputFilter;
import project.android.imageprocessing.input.GLTextureOutputRenderer;

public class ToneCurveFilter
extends MultiInputFilter {
    private int[] redPart;
    private int[] greenPart;
    private int[] bluePart;
    private int[] splineTexture;

    public ToneCurveFilter(Point[] red, Point[] green, Point[] blue, Point[] rgbComposite) {
        super(2);
        float[] fArray = this.getPreparedSpline(red);
        float[] fArray2 = this.getPreparedSpline(blue);
        float[] fArray3 = this.getPreparedSpline(green);
        float[] fArray4 = this.getPreparedSpline(rgbComposite);
        this.redPart = new int[256];
        this.greenPart = new int[256];
        this.bluePart = new int[256];
        for (int i = 0; i < 256; ++i) {
            this.redPart[i] = (int)Math.min(Math.max((float)i + fArray[i] + fArray4[i], 0.0f), 255.0f);
            this.greenPart[i] = (int)Math.min(Math.max((float)i + fArray3[i] + fArray4[i], 0.0f), 255.0f);
            this.bluePart[i] = (int)Math.min(Math.max((float)i + fArray2[i] + fArray4[i], 0.0f), 255.0f);
        }
    }

    private void createSplineTexture() {
        int[] nArray = new int[256];
        for (int i = 0; i < 256; ++i) {
            nArray[i] = this.redPart[i] & 0xFF | this.greenPart[i] << 8 & 0xFF00 | this.bluePart[i] << 16 & 0xFF0000 | 0xFF000000;
        }
        this.splineTexture = new int[1];
        GLES20.glGenTextures((int)1, (int[])this.splineTexture, (int)0);
        GLES20.glBindTexture((int)3553, (int)this.splineTexture[0]);
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9728);
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9728);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)256, (int)1, (int)0, (int)6408, (int)5121, (Buffer)IntBuffer.wrap(nArray));
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.splineTexture != null && this.splineTexture[0] != 0) {
            GLES20.glDeleteTextures((int)1, (int[])this.splineTexture, (int)0);
            this.splineTexture = null;
        }
    }

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nuniform sampler2D inputImageTexture1;\nvarying vec2 textureCoordinate;\nconst float halfPixelWidth = 1.0/512.0;void main(){\n   vec4 texColour = texture2D(inputImageTexture0,textureCoordinate);\n   float rVal;\n   if(texColour.r < halfPixelWidth) {     rVal = texture2D(inputImageTexture1, vec2(texColour.r + halfPixelWidth, 0.5)).r;\n   } else {\n     rVal = texture2D(inputImageTexture1, vec2(texColour.r - halfPixelWidth, 0.5)).r;\n   }\n   float gVal;\n   if(texColour.g < halfPixelWidth) {     gVal = texture2D(inputImageTexture1, vec2(texColour.g + halfPixelWidth, 0.5)).r;\n   } else {\n     gVal = texture2D(inputImageTexture1, vec2(texColour.g - halfPixelWidth, 0.5)).r;\n   }\n   float bVal;\n   if(texColour.b < halfPixelWidth) {     bVal = texture2D(inputImageTexture1, vec2(texColour.b + halfPixelWidth, 0.5)).r;\n   } else {\n     bVal = texture2D(inputImageTexture1, vec2(texColour.b - halfPixelWidth, 0.5)).r;\n   }\n   gl_FragColor = vec4(rVal,gVal,bVal,texColour.a);\n}\n";
    }

    private float[] getPreparedSpline(Point[] points) {
        int n;
        Arrays.sort(points, new Comparator<Point>(){

            @Override
            public int compare(Point lhs, Point rhs) {
                return lhs.x - rhs.x;
            }
        });
        List<Point> list = this.getSplineCurve(points);
        if (list.get((int)0).x > 0) {
            for (n = list.get((int)0).x; n >= 0; --n) {
                list.add(0, new Point(n, 0));
            }
        }
        if (list.get((int)(list.size() - 1)).x < 255) {
            for (n = list.get((int)(list.size() - 1)).x; n < 256; ++n) {
                list.add(new Point(n, 255));
            }
        }
        float[] fArray = new float[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Point point = list.get(i);
            Point point2 = new Point(point.x, point.x);
            float f = (float)Math.sqrt(Math.pow(point2.x - point.x, 2.0) + Math.pow(point2.y - point.y, 2.0));
            if (point2.y > point.y) {
                f = -f;
            }
            fArray[i] = f;
        }
        return fArray;
    }

    private List<Point> getSplineCurve(Point[] points) {
        double[] dArray = this.secondDerivative(points);
        int n = dArray.length;
        if (n < 1) {
            return null;
        }
        ArrayList<Point> arrayList = new ArrayList<Point>(n + 1);
        for (int i = 0; i < n - 1; ++i) {
            Point point = points[i];
            Point point2 = points[i + 1];
            for (int j = point.x; j < point2.x; ++j) {
                double d = (double)(j - point.x) / (double)(point2.x - point.x);
                double d2 = 1.0 - d;
                double d3 = d;
                double d4 = point2.x - point.x;
                double d5 = d2 * (double)point.y + d3 * (double)point2.y + d4 * d4 / 6.0 * ((d2 * d2 * d2 - d2) * dArray[i] + (d3 * d3 * d3 - d3) * dArray[i + 1]);
                if (d5 > 255.0) {
                    d5 = 255.0;
                } else if (d5 < 0.0) {
                    d5 = 0.0;
                }
                arrayList.add(new Point(j, (int)d5));
            }
        }
        if (arrayList.size() == 255) {
            arrayList.add(points[points.length - 1]);
        }
        return arrayList;
    }

    @Override
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        if (this.filterLocations.size() < 2 || !source.equals(this.filterLocations.get(0))) {
            this.clearRegisteredFilterLocations();
            this.registerFilterLocation(source, 0);
            this.registerFilterLocation(this, 1);
        }
        if (this.splineTexture == null || this.splineTexture[0] == 0) {
            this.createSplineTexture();
        }
        super.newTextureReady(this.splineTexture[0], this, newData);
        super.newTextureReady(texture, source, newData);
    }

    private double[] secondDerivative(Point[] points) {
        int n;
        int n2 = points.length;
        if (n2 <= 1) {
            return null;
        }
        double[][] dArray = new double[n2][3];
        double[] dArray2 = new double[n2];
        dArray[0][1] = 1.0;
        dArray[0][0] = 0.0;
        dArray[0][2] = 0.0;
        for (n = 1; n < n2 - 1; ++n) {
            Point point = points[n - 1];
            Point point2 = points[n];
            Point point3 = points[n + 1];
            dArray[n][0] = (double)(point2.x - point.x) / 6.0;
            dArray[n][1] = (double)(point3.x - point.x) / 3.0;
            dArray[n][2] = (double)(point3.x - point2.x) / 6.0;
            dArray2[n] = (double)(point3.y - point2.y) / (double)(point3.x - point2.x) - (double)(point2.y - point.y) / (double)(point2.x - point.x);
        }
        dArray2[0] = 0.0;
        dArray2[n2 - 1] = 0.0;
        dArray[n2 - 1][1] = 1.0;
        dArray[n2 - 1][0] = 0.0;
        dArray[n2 - 1][2] = 0.0;
        for (n = 1; n < n2; ++n) {
            double d = dArray[n][0] / dArray[n - 1][1];
            double[] dArray3 = dArray[n];
            dArray3[1] = dArray3[1] - d * dArray[n - 1][2];
            dArray[n][0] = 0.0;
            int n3 = n;
            dArray2[n3] = dArray2[n3] - d * dArray2[n - 1];
        }
        for (n = n2 - 2; n >= 0; --n) {
            double d = dArray[n][2] / dArray[n + 1][1];
            double[] dArray4 = dArray[n];
            dArray4[1] = dArray4[1] - d * dArray[n + 1][0];
            dArray[n][2] = 0.0;
            int n4 = n;
            dArray2[n4] = dArray2[n4] - d * dArray2[n + 1];
        }
        double[] dArray5 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray5[i] = dArray2[i] / dArray[i][1];
        }
        return dArray5;
    }
}

