/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.colour;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;

public class OpacityFilter
extends BasicFilter {
    private static final String UNIFORM_OPACITY = "u_Opacity";
    private int opacityHandle;
    private float opacity;

    public OpacityFilter(float opacity) {
        this.opacity = opacity;
    }

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform float u_Opacity;\nvoid main(){\n   vec4 color = texture2D(inputImageTexture0,textureCoordinate);\n   gl_FragColor = vec4(color.rgb, color.a * u_Opacity);\n}\n";
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.opacityHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_OPACITY);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform1f((int)this.opacityHandle, (float)this.opacity);
    }
}

