/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.colour;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;

public class MonochromeFilter
extends BasicFilter {
    private static final String UNIFORM_INTENSITY = "u_Intensity";
    private static final String UNIFORM_COLOUR = "u_Colour";
    private int intensityHandle;
    private int colourHandle;
    private float intensity;
    private float[] colour;

    public MonochromeFilter(float[] colour, float intensity) {
        this.intensity = intensity;
        this.colour = colour;
    }

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform float u_Intensity;\nuniform vec3 u_Colour;\nvec3 luminanceWeighting = vec3(0.2125, 0.7154, 0.0721);\nvoid main(){\n   vec4 color = texture2D(inputImageTexture0,textureCoordinate);\n   float luminance =  dot(color.rgb, luminanceWeighting);\n   vec4 desat = vec4(vec3(luminance), 1.0);\n   vec4 outputColour = vec4(\n     (desat.r < 0.5 ? (2.0 * desat.r * u_Colour.r) : (1.0 - 2.0 * (1.0 - desat.r) * (1.0 - u_Colour.r))),\n     (desat.g < 0.5 ? (2.0 * desat.g * u_Colour.g) : (1.0 - 2.0 * (1.0 - desat.g) * (1.0 - u_Colour.g))),\n     (desat.b < 0.5 ? (2.0 * desat.b * u_Colour.b) : (1.0 - 2.0 * (1.0 - desat.b) * (1.0 - u_Colour.b))),\n     1.0);\n   gl_FragColor = vec4(mix(color.rgb, outputColour.rgb, u_Intensity), color.a);\n}\n";
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.intensityHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_INTENSITY);
        this.colourHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_COLOUR);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform1f((int)this.intensityHandle, (float)this.intensity);
        GLES20.glUniform3f((int)this.colourHandle, (float)this.colour[0], (float)this.colour[1], (float)this.colour[2]);
    }
}

