/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.colour;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;

public class LuminanceThresholdFilter
extends BasicFilter {
    private static final String UNIFORM_THRESHOLD = "u_Threshold";
    private int thresholdHandle;
    private float threshold;

    public LuminanceThresholdFilter(float threshold) {
        this.threshold = threshold;
    }

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform float u_Threshold;\nvec3 luminanceWeighting = vec3(0.2125, 0.7154, 0.0721);\nvoid main(){\n   vec4 color = texture2D(inputImageTexture0,textureCoordinate);\n   float luminance = dot(color.rgb, luminanceWeighting);\n   gl_FragColor = vec4(vec3(step(u_Threshold, luminance)), color.a);\n}\n";
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.thresholdHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_THRESHOLD);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform1f((int)this.thresholdHandle, (float)this.threshold);
    }
}

