/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.colour;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;

public class LevelsFilter
extends BasicFilter {
    private static final String UNIFORM_GAMMA = "u_Gamma";
    private static final String UNIFORM_MAXIN = "u_MaxIn";
    private static final String UNIFORM_MAXOUT = "u_MaxOut";
    private static final String UNIFORM_MININ = "u_MinIn";
    private static final String UNIFORM_MINOUT = "u_MinOut";
    private float gamma;
    private float minIn;
    private float maxIn;
    private float minOut;
    private float maxOut;
    private int gammaHandle;
    private int minInHandle;
    private int maxInHandle;
    private int minOutHandle;
    private int maxOutHandle;

    public LevelsFilter(float minIn, float maxIn, float gamma, float minOut, float maxOut) {
        if (gamma < 0.0f) {
            gamma = 0.0f;
        }
        this.gamma = gamma;
        this.minIn = minIn;
        this.minOut = minOut;
        this.maxIn = maxIn;
        this.maxOut = maxOut;
    }

    @Override
    protected String getFragmentShader() {
        return "#define GammaCorrection(color, gamma)\t\t\t\t\t\t\t\t\t\t\t\tpow(color, 1.0 / gamma)\n#define LevelsControlInputRange(color, minInput, maxInput)\t\t\t\t\t\tmin(max(color - minInput, vec3(0.0)) / (maxInput - minInput), vec3(1.0))\n#define LevelsControlInput(color, minInput, gamma, maxInput)\t\t\t\t\t\tGammaCorrection(LevelsControlInputRange(color, minInput, maxInput), gamma)\n#define LevelsControlOutputRange(color, minOutput, maxOutput) \t\t\t\t\tmix(minOutput, maxOutput, color)\n#define LevelsControl(color, minInput, gamma, maxInput, minOutput, maxOutput) \tLevelsControlOutputRange(LevelsControlInput(color, minInput, gamma, maxInput), minOutput, maxOutput)\nprecision mediump float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform float u_Gamma;\nuniform float u_MinIn;\nuniform float u_MaxIn;\nuniform float u_MinOut;\nuniform float u_MaxOut;\nvoid main(){\n   vec4 color = texture2D(inputImageTexture0, textureCoordinate);\n   gl_FragColor = vec4(LevelsControl(color.rgb, vec3(u_MinIn), vec3(u_Gamma), vec3(u_MaxIn), vec3(u_MinOut), vec3(u_MaxOut)), color.a);\n}\n";
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.gammaHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_GAMMA);
        this.minInHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_MININ);
        this.maxInHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_MAXIN);
        this.minOutHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_MINOUT);
        this.maxOutHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_MAXOUT);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform1f((int)this.gammaHandle, (float)this.gamma);
        GLES20.glUniform1f((int)this.minInHandle, (float)this.minIn);
        GLES20.glUniform1f((int)this.maxInHandle, (float)this.maxIn);
        GLES20.glUniform1f((int)this.minOutHandle, (float)this.minOut);
        GLES20.glUniform1f((int)this.maxOutHandle, (float)this.maxOut);
    }
}

