/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.colour;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.opengl.GLES20;
import project.android.imageprocessing.filter.MultiInputFilter;
import project.android.imageprocessing.helper.ImageHelper;
import project.android.imageprocessing.input.GLTextureOutputRenderer;

public class ImageColorChangingFilter
extends MultiInputFilter {
    protected static final String UNIFORM_USE_LOOKUP = "useLookUp";
    private int useLookUpHandle;
    private int useLookUp = 0;
    private int lookup_texture;
    private Bitmap lookupBitmap;
    private float intensity = 1.0f;
    private int intensityHandler;

    public ImageColorChangingFilter() {
        super(2);
    }

    public ImageColorChangingFilter(Context context, int id) {
        super(2);
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inScaled = false;
        this.lookupBitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)id, (BitmapFactory.Options)options);
    }

    public ImageColorChangingFilter(Context context, String filePath) {
        super(2);
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inScaled = false;
        this.lookupBitmap = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
    }

    public synchronized void setLookupBitmap(Bitmap lookupBitmap) {
        if (this.lookup_texture != 0) {
            int[] nArray = new int[]{this.lookup_texture};
            GLES20.glDeleteTextures((int)1, (int[])nArray, (int)0);
            this.lookup_texture = 0;
        }
        this.lookupBitmap = lookupBitmap;
    }

    public void setIntensity(float intensity) {
        this.intensity = intensity;
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.lookup_texture != 0) {
            int[] nArray = new int[]{this.lookup_texture};
            GLES20.glDeleteTextures((int)1, (int[])nArray, (int)0);
            this.lookup_texture = 0;
        }
        if (this.lookupBitmap != null && !this.lookupBitmap.isRecycled()) {
            this.lookupBitmap.recycle();
            this.lookupBitmap = null;
        }
    }

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nuniform sampler2D inputImageTexture1;\nvarying vec2 textureCoordinate;\nuniform float intensity;\nuniform int useLookUp;\nvoid main(){\n  vec4 texColour = texture2D(inputImageTexture0,textureCoordinate);\n  if(useLookUp == 1){   float blueColor = texColour.b * 63.0;\n  vec2 quad1;\n  quad1.y = floor(floor(blueColor) / 8.0);\n  quad1.x = floor(blueColor) - (quad1.y * 8.0);\n  vec2 quad2;\n  quad2.y = floor(ceil(blueColor) / 8.0);\n  quad2.x = ceil(blueColor) - (quad2.y * 8.0);\n  vec2 texPos1;\n  texPos1.x = (quad1.x * 0.125) + 0.5/512.0 + ((0.125 - 1.0/512.0) * texColour.r);\n  texPos1.y = (quad1.y * 0.125) + 0.5/512.0 + ((0.125 - 1.0/512.0) * texColour.g);\n  vec2 texPos2;\n  texPos2.x = (quad2.x * 0.125) + 0.5/512.0 + ((0.125 - 1.0/512.0) * texColour.r);\n  texPos2.y = (quad2.y * 0.125) + 0.5/512.0 + ((0.125 - 1.0/512.0) * texColour.g);\n  vec4 newColor1 = texture2D(inputImageTexture1, texPos1);\n  vec4 newColor2 = texture2D(inputImageTexture1, texPos2);\n  vec4 newColor = mix(newColor1, newColor2, fract(blueColor));\n  gl_FragColor = mix(texColour, vec4(newColor.rgb, texColour.a), intensity);\n  }else{\n  gl_FragColor = texColour;\n  }\n}\n";
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.intensityHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)"intensity");
        this.useLookUpHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_USE_LOOKUP);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform1f((int)this.intensityHandler, (float)this.intensity);
        GLES20.glUniform1i((int)this.useLookUpHandle, (int)this.useLookUp);
    }

    @Override
    public synchronized void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        if (this.filterLocations.size() < 2 || !source.equals(this.filterLocations.get(0))) {
            this.clearRegisteredFilterLocations();
            this.registerFilterLocation(source, 0);
            this.registerFilterLocation(this, 1);
        }
        if (this.lookupBitmap != null) {
            this.useLookUp = 1;
            if (this.lookup_texture == 0) {
                this.lookup_texture = ImageHelper.bitmapToTexture(this.lookupBitmap);
            }
        } else {
            this.useLookUp = 0;
        }
        super.newTextureReady(this.lookup_texture, this, newData);
        super.newTextureReady(texture, source, newData);
    }

    @Override
    public void releaseFrameBuffer() {
        super.releaseFrameBuffer();
        if (this.lookup_texture != 0) {
            int[] nArray = new int[]{this.lookup_texture};
            GLES20.glDeleteTextures((int)1, (int[])nArray, (int)0);
            this.lookup_texture = 0;
        }
    }
}

