/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.colour;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;

public class HighlightShadowFilter
extends BasicFilter {
    private static final String UNIFORM_HIGHLIGHT = "u_Highlight";
    private static final String UNIFORM_SHADOW = "u_Shadow";
    private int highlightHandle;
    private int shadowHandle;
    private float highlight;
    private float shadow;

    public HighlightShadowFilter(float highlight, float shadow) {
        this.highlight = highlight;
        this.shadow = shadow;
    }

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nuniform float u_Highlight;\nuniform float u_Shadow;\nvarying vec2 textureCoordinate;\nconst vec3 luminanceWeighting = vec3(0.3, 0.3, 0.3);\nvoid main(){\n   vec4 texColour = texture2D(inputImageTexture0,textureCoordinate);\n   float luminance = dot(texColour.rgb, luminanceWeighting);\n   float s = clamp((pow(luminance, 1.0/(u_Shadow+1.0)) + (-0.76)*pow(luminance, 2.0/(u_Shadow+1.0))) - luminance, 0.0, 1.0);\n   float h = clamp((1.0 - (pow(1.0-luminance, 1.0/(2.0-u_Highlight)) + (-0.8)*pow(1.0-luminance, 2.0/(2.0-u_Highlight)))) - luminance, -1.0, 0.0);\n   vec3 result = vec3(0.0, 0.0, 0.0) + ((luminance + s + h) - 0.0) * ((texColour.rgb - vec3(0.0, 0.0, 0.0))/(luminance - 0.0));\n   gl_FragColor = vec4(result, texColour.a);\n}\n";
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.highlightHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_HIGHLIGHT);
        this.shadowHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_SHADOW);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform1f((int)this.highlightHandle, (float)this.highlight);
        GLES20.glUniform1f((int)this.shadowHandle, (float)this.shadow);
    }
}

