/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.colour;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;

public class HazeFilter
extends BasicFilter {
    private static final String UNIFORM_DISTANCE = "u_Distance";
    private static final String UNIFORM_SLOPE = "u_Slope";
    private int distanceHandle;
    private int slopeHandle;
    private float distance;
    private float slope;

    public HazeFilter(float distance, float slope) {
        this.distance = distance;
        this.slope = slope;
    }

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform float u_Distance;\nuniform float u_Slope;\nvoid main(){\n   float d = textureCoordinate.y * u_Slope + u_Distance;\n   vec4 color = vec4(d);\n   vec4 c = texture2D(inputImageTexture0,textureCoordinate);\n   vec4 result = (c - color) / (1.0-d);\n   gl_FragColor = vec4(result.rgb, c.a);\n}\n";
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.distanceHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_DISTANCE);
        this.slopeHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_SLOPE);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform1f((int)this.distanceHandle, (float)this.distance);
        GLES20.glUniform1f((int)this.slopeHandle, (float)this.slope);
    }
}

