/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.colour;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;

public class GammaFilter
extends BasicFilter {
    private static final String UNIFORM_GAMMA = "u_Gamma";
    private float gamma;
    private int gammaHandle;

    public GammaFilter(float gamma) {
        this.gamma = gamma;
    }

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform float u_Gamma;\nvoid main(){\n   vec4 color = texture2D(inputImageTexture0,textureCoordinate);\n   gl_FragColor = vec4(pow(color.rgb, vec3(u_Gamma)), color.a);\n}\n";
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.gammaHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_GAMMA);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform1f((int)this.gammaHandle, (float)this.gamma);
    }
}

