/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.colour;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;

public class FalseColourFilter
extends BasicFilter {
    private static final String UNIFORM_SHADOW_COLOUR = "u_ShadowColour";
    private static final String UNIFORM_HIGHLIGHT_COLOUR = "u_HightlightColour";
    private int shadowColourHandle;
    private int highlightColourHandle;
    private float[] shadowColour;
    private float[] highlightColour;

    public FalseColourFilter(float[] shadowColour, float[] highlightColour) {
        this.shadowColour = shadowColour;
        this.highlightColour = highlightColour;
    }

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform vec3 u_ShadowColour;\nuniform vec3 u_HightlightColour;\nvec3 luminanceWeighting = vec3(0.2125, 0.7154, 0.0721);\nvoid main(){\n   vec4 color = texture2D(inputImageTexture0,textureCoordinate);\n   float luminance =  dot(color.rgb, luminanceWeighting);\n   gl_FragColor = vec4(mix(u_ShadowColour, u_HightlightColour, luminance), color.a);\n}\n";
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.shadowColourHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_SHADOW_COLOUR);
        this.highlightColourHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_HIGHLIGHT_COLOUR);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform3f((int)this.shadowColourHandle, (float)this.shadowColour[0], (float)this.shadowColour[1], (float)this.shadowColour[2]);
        GLES20.glUniform3f((int)this.highlightColourHandle, (float)this.highlightColour[0], (float)this.highlightColour[1], (float)this.highlightColour[2]);
    }
}

