/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.colour;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;

public class ContrastFilter
extends BasicFilter {
    static final String UNIFORM_CONTRAST = "u_Contrast";
    private float contrast;
    private int contrastHandle;

    public ContrastFilter(float contrast) {
        this.setContrast(contrast);
    }

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform float u_Contrast;\nvoid main(){\n   vec4 color = texture2D(inputImageTexture0,textureCoordinate);\n   gl_FragColor = vec4(((color.rgb - vec3(0.5)) * u_Contrast + vec3(0.5)), color.a);\n}\n";
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.contrastHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_CONTRAST);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform1f((int)this.contrastHandle, (float)this.contrast);
    }

    public void setContrast(float contrast) {
        this.contrast = contrast;
    }
}

