/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.colour;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;

public class ColourMatrixFilter
extends BasicFilter {
    private static final String UNIFORM_COLORMATRIX = "u_ColorMatrix";
    private static final String UNIFORM_INTENSITY = "u_Intensity";
    private float[] colorMatrix;
    private float intensity;
    private int colorMatrixHandle;
    private int intensityHandle;

    public ColourMatrixFilter(float[] colorMatrix, float intensity) {
        this.colorMatrix = colorMatrix;
        if (intensity < 0.0f) {
            intensity = 0.0f;
        }
        if (intensity > 1.0f) {
            intensity = 1.0f;
        }
        this.intensity = intensity;
    }

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform float u_Intensity;\nuniform mat4 u_ColorMatrix;\nvoid main(){\n   vec4 color = texture2D(inputImageTexture0,textureCoordinate);\n   vec4 matrixResult = vec4(color.rgb, 1.0) * u_ColorMatrix;\n   vec4 colorResult = u_Intensity * matrixResult + (1.0 - u_Intensity) * color;\n   gl_FragColor = vec4(colorResult.rgb, color.a);\n}\n";
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.colorMatrixHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_COLORMATRIX);
        this.intensityHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_INTENSITY);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniformMatrix4fv((int)this.colorMatrixHandle, (int)1, (boolean)false, (float[])this.colorMatrix, (int)0);
        GLES20.glUniform1f((int)this.intensityHandle, (float)this.intensity);
    }
}

