/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.colour;

import project.android.imageprocessing.filter.CompositeFilter;
import project.android.imageprocessing.filter.colour.GreyScaleFilter;
import project.android.imageprocessing.filter.processing.BoxBlurFilter;

public class AdaptiveThresholdFilter
extends CompositeFilter {
    public AdaptiveThresholdFilter() {
        super(2);
        GreyScaleFilter greyScaleFilter = new GreyScaleFilter();
        BoxBlurFilter boxBlurFilter = new BoxBlurFilter();
        greyScaleFilter.addTarget(boxBlurFilter);
        boxBlurFilter.addTarget(this);
        greyScaleFilter.addTarget(this);
        this.registerFilterLocation(greyScaleFilter, 0);
        this.registerFilterLocation(boxBlurFilter, 1);
        this.registerInitialFilter(greyScaleFilter);
        this.registerTerminalFilter(greyScaleFilter);
        this.registerTerminalFilter(boxBlurFilter);
    }

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nuniform sampler2D inputImageTexture1;\nvarying vec2 textureCoordinate;\nvoid main(){\n   vec4 luminance = texture2D(inputImageTexture0,textureCoordinate);\n   vec4 blur = texture2D(inputImageTexture1,textureCoordinate);\n   gl_FragColor = vec4(vec3(step(blur - 0.05, luminance)), 1.0);\n}\n";
    }
}

