/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.blend;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.MultiInputFilter;

public class ChromaKeyBlendFilter
extends MultiInputFilter {
    private static final String UNIFORM_COLOUR = "u_Colour";
    private static final String UNIFORM_THRESHOLD = "u_Threshold";
    private static final String UNIFORM_SMOOTHING = "u_Smoothing";
    private int colourHandle;
    private int thresholdHandle;
    private int smoothingHandle;
    private float[] colour;
    private float threshold;
    private float smoothing;

    public ChromaKeyBlendFilter(float[] colour, float threshold, float smoothing) {
        super(2);
        this.colour = colour;
        this.threshold = threshold;
        this.smoothing = smoothing;
    }

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nuniform sampler2D inputImageTexture1;\nvarying vec2 textureCoordinate;\nuniform vec3 u_Colour;\nuniform float u_Threshold;\nuniform float u_Smoothing;\nvoid main(){\n   vec4 color = texture2D(inputImageTexture0,textureCoordinate);\n   float maskY = 0.2989 * u_Colour.r + 0.5866 * u_Colour.g + 0.1145 * u_Colour.b;   float maskCr = 0.7132 * (u_Colour.r - maskY);   float maskCb = 0.5647 * (u_Colour.b - maskY);   float Y = 0.2989 * color.r + 0.5866 * color.g + 0.1145 * color.b;   float Cr = 0.7132 * (color.r - Y);   float Cb = 0.5647 * (color.b - Y);   float blendValue = smoothstep(u_Threshold, u_Threshold + u_Smoothing, distance(vec2(Cr, Cb), vec2(maskCr, maskCb)));   gl_FragColor = mix(color, texture2D(inputImageTexture1,textureCoordinate), blendValue);\n}\n";
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.colourHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_COLOUR);
        this.thresholdHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_THRESHOLD);
        this.smoothingHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_SMOOTHING);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform3f((int)this.colourHandle, (float)this.colour[0], (float)this.colour[1], (float)this.colour[2]);
        GLES20.glUniform1f((int)this.thresholdHandle, (float)this.threshold);
        GLES20.glUniform1f((int)this.smoothingHandle, (float)this.smoothing);
    }
}

