/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.blend;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.MultiInputFilter;

public class AlphaBlendFilter
extends MultiInputFilter {
    private static final String UNIFORM_MIX_PERCENT = "u_MixPercent";
    private float mixPercent;
    private int mixPercentHandle;

    public AlphaBlendFilter(float mixPercent) {
        super(2);
        this.mixPercent = mixPercent;
    }

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nuniform sampler2D inputImageTexture1;\nvarying vec2 textureCoordinate;\nuniform float u_MixPercent;\nvoid main(){\n   vec4 tex1 = texture2D(inputImageTexture0, textureCoordinate);\n   vec4 tex2 = texture2D(inputImageTexture1, textureCoordinate);\n   gl_FragColor = vec4(mix(tex1.rgb, tex2.rgb, tex2.a * u_MixPercent), tex1.a);\n}\n";
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.mixPercentHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_MIX_PERCENT);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform1f((int)this.mixPercentHandle, (float)this.mixPercent);
    }
}

