/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.TwoPassFilter;

public abstract class TwoPassMultiPixelFilter
extends TwoPassFilter {
    protected static final String UNIFORM_TEXELWIDTH = "texelWidthOffset";
    protected static final String UNIFORM_TEXELHEIGHT = "texelHeightOffset";
    protected float texelWidth;
    protected float texelHeight;
    private int texelWidthHandle;
    private int texelHeightHandle;

    @Override
    protected void handleSizeChange() {
        super.handleSizeChange();
        this.texelWidth = 1.0f / (float)this.getWidth();
        this.texelHeight = 1.0f / (float)this.getHeight();
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.texelWidthHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_TEXELWIDTH);
        this.texelHeightHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_TEXELHEIGHT);
    }

    @Override
    protected void passShaderValues() {
        if (this.getCurrentPass() == 1) {
            this.texelWidth = 1.0f / (float)this.getWidth();
            this.texelHeight = 0.0f;
        } else {
            this.texelWidth = 0.0f;
            this.texelHeight = 1.0f / (float)this.getHeight();
        }
        super.passShaderValues();
        GLES20.glUniform1f((int)this.texelWidthHandle, (float)this.texelWidth);
        GLES20.glUniform1f((int)this.texelHeightHandle, (float)this.texelHeight);
    }
}

