/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter;

import android.graphics.PointF;
import android.opengl.GLES20;
import project.android.imageprocessing.filter.MultiInputFilter;

public class SplitFilter
extends MultiInputFilter {
    private static final String UNIFORM_MIX_PERCENT = "mixturePercent";
    private static final String UNIFORM_LINE_CENTER = "center";
    private static final String UNIFORM_WIDTH_HEIGHT_RATIO = "imageWidthAndHeightRatio";
    private static final String UNIFORM_LINE_ROTATE_ANGLE = "tiltShiftRotationAngle";
    private float mixPercent;
    private float angle = 1.5707964f;
    private float widthHeighScale = 1.0f;
    private PointF centerPoint = new PointF(0.5f, 0.5f);
    private int mixPercentHandle;
    private int widthHeightHandle;
    private int lineRotateHandle;
    private int centerHandle;
    private boolean isVShader = false;
    private static final String hSplitShaderStr = "precision lowp float;\nuniform sampler2D inputImageTexture0;\nuniform sampler2D inputImageTexture1;\nvarying vec2 textureCoordinate;\n uniform float mixturePercent;\n uniform vec2 center;  uniform float tiltShiftRotationAngle; uniform float imageWidthAndHeightRatio; \n void main() {\n     vec4 pic0 = texture2D(inputImageTexture0, textureCoordinate);\n     vec4 pic1 = texture2D(inputImageTexture1, textureCoordinate); \n     vec2 normalizedCenter = center * vec2(imageWidthAndHeightRatio, 1.0); \n     float angleSub = abs(tiltShiftRotationAngle - 3.1415926/2.0); \n     if (angleSub <= 0.01) {\n           float mixFactor = clamp(abs((textureCoordinate.x - mixturePercent)/0.01),0.0,1.0);\n             if(mixturePercent < 0.02){                gl_FragColor = pic1;              }             else if (textureCoordinate.x >= mixturePercent && textureCoordinate.x <= mixturePercent + 1.0) {\n               gl_FragColor = mix(pic0,pic1,mixFactor);\n             } else {\n               gl_FragColor = pic0;\n             } \n      } else {\n          float a = -tan(tiltShiftRotationAngle);          float b = normalizedCenter.y - a * normalizedCenter.x;           float mixFactor = clamp((abs(a*textureCoordinate.x - textureCoordinate.y + b)/sqrt(a*a + b*b))/0.01,0.0,1.0);          float d = -tan(tiltShiftRotationAngle) * textureCoordinate.x + normalizedCenter.y + tan(tiltShiftRotationAngle) * normalizedCenter.x;\n          if(tiltShiftRotationAngle >= 3.1415926/2.0){\n              if (d  >= textureCoordinate.y) {\n                    gl_FragColor = mix(pic0,pic1,mixFactor);\n                 } else {\n                    gl_FragColor = pic0;\n                 }\n           }\n           else{\n                 if (d < textureCoordinate.y) {\n                     gl_FragColor = mix(pic0,pic1,mixFactor);\n                 } else {\n                     gl_FragColor = pic0;\n                   }\n            }\n      } }";
    private static final String vplitShaderStr = "precision lowp float;\nuniform sampler2D inputImageTexture0;\nuniform sampler2D inputImageTexture1;\nvarying vec2 textureCoordinate;\n uniform float mixturePercent;\n uniform vec2 center;  uniform float tiltShiftRotationAngle; uniform float imageWidthAndHeightRatio; \n void main() {\n     vec4 pic0 = texture2D(inputImageTexture0, textureCoordinate);\n     vec4 pic1 = texture2D(inputImageTexture1, textureCoordinate); \n     vec2 normalizedCenter = center * vec2(imageWidthAndHeightRatio, 1.0); \n     float angleSub = abs(tiltShiftRotationAngle - 3.1415926/2.0); \n           float mixFactor = clamp(0.0,abs((textureCoordinate.y - mixturePercent)/0.01),1.0);\n             if(mixturePercent < 0.02){                gl_FragColor = pic1;              }             else if (textureCoordinate.y >= mixturePercent && textureCoordinate.y <= mixturePercent + 1.0) {\n               gl_FragColor = mix(pic0,pic1,mixFactor);\n             } else {\n               gl_FragColor = pic0;\n             } \n}";

    public void setVShader(boolean VShader) {
        this.isVShader = VShader;
    }

    public SplitFilter() {
        super(2);
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.mixPercentHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_MIX_PERCENT);
        this.widthHeightHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_WIDTH_HEIGHT_RATIO);
        this.lineRotateHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_LINE_ROTATE_ANGLE);
        this.centerHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_LINE_CENTER);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform1f((int)this.mixPercentHandle, (float)this.mixPercent);
        GLES20.glUniform1f((int)this.widthHeightHandle, (float)this.widthHeighScale);
        GLES20.glUniform1f((int)this.lineRotateHandle, (float)this.angle);
        GLES20.glUniform2f((int)this.centerHandle, (float)this.centerPoint.x, (float)this.centerPoint.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMixValue(float value) {
        Object object = this.getLockObject();
        synchronized (object) {
            this.mixPercent = this.isVShader ? 1.0f - value : value;
            GLES20.glUniform1f((int)this.mixPercentHandle, (float)this.mixPercent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCenterPoint(PointF pointf, float angleF) {
        Object object = this.getLockObject();
        synchronized (object) {
            this.centerPoint = pointf;
            this.angle = angleF;
            this.mixPercent = pointf.x;
            GLES20.glUniform1f((int)this.mixPercentHandle, (float)this.mixPercent);
            GLES20.glUniform1f((int)this.lineRotateHandle, (float)this.angle);
            GLES20.glUniform2f((int)this.centerHandle, (float)this.centerPoint.x, (float)this.centerPoint.y);
        }
    }

    @Override
    protected String getFragmentShader() {
        return this.isVShader ? vplitShaderStr : hSplitShaderStr;
    }
}

