/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter;

import java.util.ArrayList;
import java.util.List;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.filter.SingleLineGroupFilter;
import project.android.imageprocessing.input.GLTextureOutputRenderer;
import project.android.imageprocessing.inter.IVideoTrackTime;

public class SingleLineGroupFilterPlus
extends SingleLineGroupFilter
implements IVideoTrackTime {
    private List<BasicFilter> mFilters;
    private List<BasicFilter> mVideoTrackList;
    private long mCurtimeStamp;
    private List<BasicFilter> updateFilters;

    public SingleLineGroupFilterPlus(List<BasicFilter> filters) {
        super(filters);
        this.mFilters = filters;
        if (this.mVideoTrackList == null) {
            this.mVideoTrackList = new ArrayList<BasicFilter>();
        }
        for (BasicFilter basicFilter : this.mFilters) {
            if (!(basicFilter instanceof IVideoTrackTime)) continue;
            this.mVideoTrackList.add(basicFilter);
        }
    }

    @Override
    public synchronized void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        if (this.updateFilters != null) {
            this.updateInnerFilters(this.updateFilters);
            this.updateFilters = null;
        }
        for (BasicFilter basicFilter : this.mVideoTrackList) {
            IVideoTrackTime iVideoTrackTime = (IVideoTrackTime)((Object)basicFilter);
            iVideoTrackTime.setTimeStamp(this.mCurtimeStamp);
        }
        super.newTextureReady(texture, source, newData);
    }

    public synchronized void updateFilter(List<BasicFilter> filters) {
        if (filters != null && filters.size() > 0) {
            this.updateFilters = filters;
        }
    }

    private void updateInnerFilters(List<BasicFilter> filters) {
        if (this.mFilters != null && this.mFilters.size() > 0) {
            for (BasicFilter basicFilter : this.mFilters) {
                this.removeInitialFilter(basicFilter);
                this.removeTerminalFilter(basicFilter);
                this.removeFilter(basicFilter);
                basicFilter.clearTarget();
            }
        }
        if (this.mVideoTrackList != null) {
            this.mVideoTrackList.clear();
        }
        this.mFilters = filters;
        if (filters.size() > 0) {
            BasicFilter basicFilter;
            BasicFilter basicFilter2 = filters.get(0);
            basicFilter = filters.get(filters.size() - 1);
            this.registerInitialFilter(basicFilter2);
            BasicFilter basicFilter3 = null;
            for (int i = 0; i <= filters.size() - 1; ++i) {
                BasicFilter basicFilter4 = filters.get(i);
                basicFilter4.clearTarget();
                if (basicFilter3 == null) {
                    basicFilter3 = basicFilter4;
                } else {
                    basicFilter3.addTarget(filters.get(i));
                }
                if (i > 0 && i < filters.size() - 1) {
                    this.registerFilter(basicFilter4);
                }
                basicFilter3 = filters.get(i);
            }
            basicFilter.addTarget(this);
            this.registerTerminalFilter(basicFilter);
        }
        for (BasicFilter basicFilter : this.mFilters) {
            if (!(basicFilter instanceof IVideoTrackTime)) continue;
            this.mVideoTrackList.add(basicFilter);
        }
    }

    @Override
    public List<BasicFilter> getFilters() {
        return this.mFilters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addEndFilter(BasicFilter filter) {
        Object object = this.getLockObject();
        synchronized (object) {
            if (filter == null) {
                return;
            }
            if (this.mFilters.size() > 0 && filter != null) {
                List<BasicFilter> list = this.getTerminalFilters();
                if (list.size() == 1) {
                    BasicFilter basicFilter = list.get(0);
                    this.removeTerminalFilter(basicFilter);
                    this.registerFilter(basicFilter);
                    basicFilter.clearTarget();
                    basicFilter.addTarget(filter);
                    filter.addTarget(this);
                    this.registerTerminalFilter(filter);
                    this.mFilters.add(filter);
                }
            } else {
                this.registerInitialFilter(filter);
                filter.addTarget(this);
                this.registerTerminalFilter(filter);
                this.mFilters.add(filter);
            }
            if (this.mVideoTrackList != null) {
                this.mVideoTrackList.clear();
            }
            for (BasicFilter basicFilter : this.mFilters) {
                if (!(basicFilter instanceof IVideoTrackTime)) continue;
                this.mVideoTrackList.add(basicFilter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addHeadFilter(BasicFilter filter) {
        Object object = this.getLockObject();
        synchronized (object) {
            if (this.mFilters.size() > 0 && filter != null) {
                List<BasicFilter> list = this.getInitialFilters();
                if (list.size() == 1) {
                    BasicFilter basicFilter = list.get(0);
                    this.removeInitialFilter(basicFilter);
                    this.registerInitialFilter(filter);
                    filter.clearTarget();
                    filter.addTarget(basicFilter);
                    this.registerFilter(basicFilter);
                    this.mFilters.add(filter);
                }
            } else {
                this.registerInitialFilter(filter);
                filter.addTarget(this);
                this.registerTerminalFilter(filter);
                this.mFilters.add(filter);
            }
            if (this.mVideoTrackList != null) {
                this.mVideoTrackList.clear();
            }
            for (BasicFilter basicFilter : this.mFilters) {
                if (!(basicFilter instanceof IVideoTrackTime)) continue;
                this.mVideoTrackList.add(basicFilter);
            }
        }
    }

    public synchronized void removeFilterFromLine(BasicFilter removeFilter) {
        if (removeFilter == null) {
            return;
        }
        for (int i = 0; i < this.mFilters.size(); ++i) {
            BasicFilter basicFilter = this.mFilters.get(i);
            BasicFilter basicFilter2 = null;
            BasicFilter basicFilter3 = null;
            if (basicFilter != removeFilter) continue;
            if (i > 0) {
                basicFilter2 = this.mFilters.get(i - 1);
            }
            if (i + 1 < this.mFilters.size()) {
                basicFilter3 = this.mFilters.get(i + 1);
            }
            if (basicFilter2 == null && basicFilter3 != null) {
                basicFilter.clearTarget();
                this.removeInitialFilter(basicFilter);
                this.registerInitialFilter(basicFilter3);
            } else if (basicFilter3 == null && basicFilter2 != null) {
                basicFilter2.clearTarget();
                basicFilter.clearTarget();
                this.removeTerminalFilter(basicFilter);
                this.registerTerminalFilter(basicFilter2);
                basicFilter2.addTarget(this);
            } else if (basicFilter2 != null && basicFilter3 != null) {
                basicFilter2.removeTarget(basicFilter);
                basicFilter.removeTarget(basicFilter3);
                this.removeFilter(basicFilter);
                basicFilter2.addTarget(basicFilter3);
            }
            this.mFilters.remove(basicFilter);
            if (!(basicFilter instanceof IVideoTrackTime)) continue;
            this.mVideoTrackList.remove(basicFilter);
        }
    }

    @Override
    public void setTimeStamp(long ms) {
        this.mCurtimeStamp = ms;
    }
}

