/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter;

import java.util.List;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.filter.OnUpdateFrameTimestamp;
import project.android.imageprocessing.input.GLTextureOutputRenderer;
import project.android.imageprocessing.output.GLTextureInputRenderer;

public class ProcessByTimeFilter
extends BasicFilter
implements OnUpdateFrameTimestamp {
    private long curFramePts;
    private long stopRenderPts;
    private long startRenderPts;
    private BasicFilter holdFilter;

    public ProcessByTimeFilter(BasicFilter filter) {
        this.holdFilter = filter != null ? filter : new BasicFilter(){

            @Override
            public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
                super.newTextureReady(texture, source, newData);
            }
        };
        this.addTarget(this.holdFilter);
    }

    public void setStartPts(long startPts) {
        this.startRenderPts = startPts;
    }

    public void setStopRenderPts(long stopRenderPts) {
        this.stopRenderPts = stopRenderPts;
    }

    @Override
    public void onDrawFrame() {
        if (this.holdFilter != null) {
            if (this.curFramePts >= this.startRenderPts && this.curFramePts <= this.stopRenderPts) {
                for (GLTextureInputRenderer gLTextureInputRenderer : this.targets) {
                    if (gLTextureInputRenderer == null) continue;
                    gLTextureInputRenderer.newTextureReady(this.texture_in, this, true);
                }
            } else {
                for (GLTextureInputRenderer gLTextureInputRenderer : this.holdFilter.getTargets()) {
                    if (gLTextureInputRenderer == null) continue;
                    gLTextureInputRenderer.newTextureReady(this.texture_in, this, true);
                }
            }
        } else {
            super.onDrawFrame();
        }
    }

    @Override
    public synchronized void addTarget(GLTextureInputRenderer target) {
        if (this.holdFilter != null) {
            this.holdFilter.addTarget(target);
        } else {
            super.addTarget(target);
        }
    }

    @Override
    public void removeTarget(GLTextureInputRenderer target) {
        if (this.holdFilter != null) {
            this.holdFilter.removeTarget(target);
        } else {
            super.removeTarget(target);
        }
    }

    @Override
    public void clearTarget() {
        if (this.holdFilter != null) {
            this.holdFilter.clearTarget();
        } else {
            super.clearTarget();
        }
    }

    @Override
    public List<GLTextureInputRenderer> getTargets() {
        if (this.holdFilter != null) {
            return this.holdFilter.getTargets();
        }
        return super.getTargets();
    }

    @Override
    public void updateFrameTimestamp(long pts) {
        this.curFramePts = pts;
    }

    @Override
    public void destroy() {
        if (this.holdFilter != null) {
            this.holdFilter.destroy();
        }
        super.destroy();
    }
}

