/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter;

import android.graphics.PointF;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.util.Log;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import project.android.imageprocessing.filter.BasicFilter;

public class ObjectOverLayFilter
extends BasicFilter {
    public static final String ATTRIBUTE_MVP_MATRIX = "uMVPMatrix";
    public static final String ATTRIBUTE_DECORATION_SIZE = "decorationSize";
    public static final String ATTRIBUTE_POSITION_2 = "position2";
    private int decorateHandler;
    private int mVPMatrixHandler;
    protected int positionHandle2;
    static final int COORDS_PER_VERTEX = 2;
    private boolean needUpdate;
    protected final float[] mProjectionMatrix = new float[16];
    protected final float[] mViewMatrix = new float[16];
    protected final short[] drawOrder = new short[]{0, 1, 2, 0, 2, 3};
    protected final int vertexStride = 8;
    protected Object maskListLock = new Object();
    protected FloatBuffer vertexBuffer;
    protected FloatBuffer fvertexBuffer;
    protected float stickerScale;
    protected float[] texData0;
    protected ShortBuffer drawListBuffer;
    protected List<float[]> mvpLists = Collections.synchronizedList(new ArrayList());
    private final String vertexShaderCode = "uniform mat4 uMVPMatrix;attribute vec4 position;\nattribute vec4   position2 ; attribute vec4 inputTextureCoordinate;\nvarying vec2 textureCoordinate;\nuniform vec2 decorationSize;\nvoid main() {  gl_Position = position;   vec2 coord = position2.xy;  coord = (coord) / decorationSize;\n  textureCoordinate = vec2(1.0 - (coord.x + 0.5),(coord.y + 0.5));\n}";
    private final String fragmentShaderCode = "precision mediump float;uniform sampler2D inputImageTexture;varying vec2 textureCoordinate;\nvoid main() {   vec4 color1  = texture2D(inputImageTexture,textureCoordinate);\n   vec4 color2 = vec4(0.0);\n   vec4 outputColor;\n   float a = color1.a + color2.a * (1.0 - color1.a);\n   outputColor.r = (color1.r * color1.a + color2.r * color2.a * (1.0 - color1.a))/a;\n   outputColor.g = (color1.g * color1.a + color2.g * color2.a * (1.0 - color1.a))/a;\n   outputColor.b = (color1.b * color1.a + color2.b * color2.a * (1.0 - color1.a))/a;\n   outputColor.a = 1.0;\n   gl_FragColor = color1;\n}";
    private float mW;
    private float mH;
    private float mAngle;
    private PointF centerPoint;

    public ObjectOverLayFilter(float scale) {
        float f = 0.5f;
        this.stickerScale = scale;
        float[] fArray = new float[]{-f, f * this.stickerScale, -f, -f * this.stickerScale, f, -f * this.stickerScale, f, f * this.stickerScale};
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(fArray.length * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        this.vertexBuffer = byteBuffer.asFloatBuffer();
        this.vertexBuffer.put(fArray);
        this.vertexBuffer.position(0);
        this.texData0 = new float[]{-f, f * this.stickerScale, 0.0f, 1.0f, -f, -f * this.stickerScale, 0.0f, 1.0f, f, -f * this.stickerScale, 0.0f, 1.0f, f, f * this.stickerScale, 0.0f, 1.0f};
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(this.drawOrder.length * 2);
        byteBuffer2.order(ByteOrder.nativeOrder());
        this.drawListBuffer = byteBuffer2.asShortBuffer();
        this.drawListBuffer.put(this.drawOrder);
        this.drawListBuffer.position(0);
        Matrix.setIdentityM((float[])this.mViewMatrix, (int)0);
        this.mViewMatrix[0] = -1.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOverlayPosition(float w, float h, PointF centerPoint, float angle) {
        Object object = this.maskListLock;
        synchronized (object) {
            if (centerPoint == null) {
                return;
            }
            this.mW = w;
            this.mH = h;
            this.centerPoint = centerPoint;
            this.mAngle = angle;
            this.needUpdate = true;
        }
    }

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;uniform sampler2D inputImageTexture;varying vec2 textureCoordinate;\nvoid main() {   vec4 color1  = texture2D(inputImageTexture,textureCoordinate);\n   vec4 color2 = vec4(0.0);\n   vec4 outputColor;\n   float a = color1.a + color2.a * (1.0 - color1.a);\n   outputColor.r = (color1.r * color1.a + color2.r * color2.a * (1.0 - color1.a))/a;\n   outputColor.g = (color1.g * color1.a + color2.g * color2.a * (1.0 - color1.a))/a;\n   outputColor.b = (color1.b * color1.a + color2.b * color2.a * (1.0 - color1.a))/a;\n   outputColor.a = 1.0;\n   gl_FragColor = color1;\n}";
    }

    @Override
    protected String getVertexShader() {
        return "uniform mat4 uMVPMatrix;attribute vec4 position;\nattribute vec4   position2 ; attribute vec4 inputTextureCoordinate;\nvarying vec2 textureCoordinate;\nuniform vec2 decorationSize;\nvoid main() {  gl_Position = position;   vec2 coord = position2.xy;  coord = (coord) / decorationSize;\n  textureCoordinate = vec2(1.0 - (coord.x + 0.5),(coord.y + 0.5));\n}";
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.positionHandle2 = GLES20.glGetAttribLocation((int)this.programHandle, (String)ATTRIBUTE_POSITION_2);
        this.mVPMatrixHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)ATTRIBUTE_MVP_MATRIX);
        this.decorateHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)ATTRIBUTE_DECORATION_SIZE);
    }

    @Override
    protected void bindShaderAttributes() {
        super.bindShaderAttributes();
        GLES20.glBindAttribLocation((int)this.programHandle, (int)2, (String)ATTRIBUTE_MVP_MATRIX);
        GLES20.glBindAttribLocation((int)this.programHandle, (int)3, (String)ATTRIBUTE_DECORATION_SIZE);
    }

    protected void passShaderValues(float[] mvpMatrix) {
        this.renderVertices.position(0);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(mvpMatrix.length * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        this.fvertexBuffer = byteBuffer.asFloatBuffer();
        this.fvertexBuffer.put(mvpMatrix);
        this.fvertexBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.fvertexBuffer);
        GLES20.glVertexAttribPointer((int)this.positionHandle2, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.vertexBuffer);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle2);
        this.textureVertices[this.curRotation].position(0);
        GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.textureVertices[this.curRotation]);
        GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.texture_in);
        GLES20.glUniform1i((int)this.textureHandle, (int)0);
    }

    private void caculateTransform() {
        if (!this.needUpdate) {
            return;
        }
        float f = this.mW;
        float f2 = this.mH;
        float f3 = -(this.centerPoint.x * 2.0f - 1.0f);
        float f4 = -this.centerPoint.y * 2.0f + 1.0f;
        float f5 = this.mAngle;
        this.centerPoint.x = f3;
        this.centerPoint.y = f4;
        float[] fArray = new float[16];
        float[] fArray2 = new float[16];
        Matrix.setIdentityM((float[])fArray2, (int)0);
        Matrix.translateM((float[])fArray2, (int)0, (float)(-f3), (float)f4, (float)0.0f);
        Matrix.multiplyMM((float[])fArray, (int)0, (float[])this.mViewMatrix, (int)0, (float[])this.mProjectionMatrix, (int)0);
        Matrix.multiplyMM((float[])fArray, (int)0, (float[])fArray2, (int)0, (float[])fArray, (int)0);
        Matrix.rotateM((float[])fArray, (int)0, (float)f5, (float)0.0f, (float)0.0f, (float)1.0f);
        Matrix.scaleM((float[])fArray, (int)0, (float)(f * 1.0f), (float)(f2 * 1.0f), (float)1.0f);
        Matrix.multiplyMM((float[])fArray2, (int)0, (float[])fArray, (int)0, (float[])this.texData0, (int)0);
        float[] fArray3 = new float[]{fArray2[0], fArray2[1], fArray2[4], fArray2[5], fArray2[8], fArray2[9], fArray2[12], fArray2[13]};
        if (null != this.mvpLists) {
            this.mvpLists.clear();
        }
        Log.e((String)"zk setOverlayPosition out", (String)Arrays.toString(fArray3));
        this.mvpLists.add(fArray3);
        this.needUpdate = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawSub() {
        this.caculateTransform();
        GLES20.glViewport((int)0, (int)0, (int)this.getWidth(), (int)this.getHeight());
        GLES20.glUseProgram((int)this.programHandle);
        GLES20.glClear((int)16640);
        GLES20.glClearColor((float)this.getBackgroundRed(), (float)this.getBackgroundGreen(), (float)this.getBackgroundBlue(), (float)this.getBackgroundAlpha());
        Object object = this.maskListLock;
        synchronized (object) {
            for (float[] fArray : this.mvpLists) {
                this.passShaderValues(fArray);
                this.draw();
            }
        }
    }

    public void draw() {
        GLES20.glUniform2f((int)this.decorateHandler, (float)1.0f, (float)this.stickerScale);
        GLES20.glDrawElements((int)4, (int)this.drawOrder.length, (int)5123, (Buffer)this.drawListBuffer);
        GLES20.glDisableVertexAttribArray((int)this.positionHandle);
    }
}

