/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;

public abstract class MultiPixelRenderer
extends BasicFilter {
    protected static final String UNIFORM_TEXELWIDTH = "u_TexelWidth";
    protected static final String UNIFORM_TEXELHEIGHT = "u_TexelHeight";
    protected float texelWidth;
    protected float texelHeight;
    private int texelWidthHandle;
    private int texelHeightHandle;

    @Override
    protected void handleSizeChange() {
        super.handleSizeChange();
        this.texelWidth = 1.0f / (float)this.getWidth();
        this.texelHeight = 1.0f / (float)this.getHeight();
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.texelWidthHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_TEXELWIDTH);
        this.texelHeightHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_TEXELHEIGHT);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform1f((int)this.texelWidthHandle, (float)this.texelWidth);
        GLES20.glUniform1f((int)this.texelHeightHandle, (float)this.texelHeight);
    }
}

