/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter;

import android.opengl.GLES20;
import java.util.ArrayList;
import java.util.List;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.input.GLTextureOutputRenderer;

public abstract class MultiInputFilter
extends BasicFilter {
    protected int[] texture;
    protected List<GLTextureOutputRenderer> texturesReceived;
    protected List<GLTextureOutputRenderer> filterLocations;
    private int numOfInputs;
    private int[] textureHandle;

    public MultiInputFilter(int numOfInputs) {
        this.numOfInputs = numOfInputs;
        this.textureHandle = new int[numOfInputs - 1];
        this.texture = new int[numOfInputs - 1];
        this.texturesReceived = new ArrayList<GLTextureOutputRenderer>(numOfInputs);
        this.filterLocations = new ArrayList<GLTextureOutputRenderer>(numOfInputs);
    }

    public void clearRegisteredFilterLocations() {
        this.filterLocations.clear();
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        for (int i = 0; i < this.numOfInputs - 1; ++i) {
            this.textureHandle[i] = GLES20.glGetUniformLocation((int)this.programHandle, (String)("inputImageTexture" + (i + 1)));
        }
    }

    @Override
    public synchronized void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        int n;
        if (!this.texturesReceived.contains(source)) {
            this.texturesReceived.add(source);
            if (newData) {
                this.markAsDirty();
            }
        }
        if ((n = this.filterLocations.lastIndexOf(source)) == 0) {
            this.texture_in = texture;
        } else {
            this.texture[n - 1] = texture;
        }
        if (this.texturesReceived.size() == this.numOfInputs) {
            this.setWidth(source.getWidth());
            this.setHeight(source.getHeight());
            this.onDrawFrame();
            this.texturesReceived.clear();
        }
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        this.passTextureValues();
    }

    protected void passTextureValues() {
        int n = 0;
        for (int i = 0; i < this.numOfInputs - 1; ++i) {
            switch (i) {
                case 0: {
                    n = 33985;
                    break;
                }
                case 1: {
                    n = 33986;
                    break;
                }
                case 2: {
                    n = 33987;
                    break;
                }
                case 3: {
                    n = 33988;
                    break;
                }
                case 4: {
                    n = 33989;
                    break;
                }
                case 5: {
                    n = 33990;
                    break;
                }
                case 6: {
                    n = 33991;
                    break;
                }
                case 7: {
                    n = 33992;
                    break;
                }
                case 8: {
                    n = 33993;
                }
            }
            GLES20.glActiveTexture((int)n);
            GLES20.glBindTexture((int)3553, (int)this.texture[i]);
            GLES20.glUniform1i((int)this.textureHandle[i], (int)(i + 1));
        }
    }

    public void registerFilterLocation(GLTextureOutputRenderer filter) {
        if (!this.filterLocations.contains(filter)) {
            this.filterLocations.add(filter);
        }
    }

    public void registerFilterLocation(GLTextureOutputRenderer filter, int location) {
        if (this.filterLocations.contains(filter)) {
            this.filterLocations.remove(filter);
        }
        this.filterLocations.add(location, filter);
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.texture != null && this.texture.length > 0) {
            for (int i = 0; i < this.texture.length; ++i) {
                if (this.texture[i] <= 0) continue;
                int[] nArray = new int[]{this.texture[i]};
                GLES20.glDeleteTextures((int)1, (int[])nArray, (int)0);
            }
        }
    }
}

