/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter;

import java.util.ArrayList;
import java.util.List;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.input.GLTextureOutputRenderer;
import project.android.imageprocessing.output.GLTextureInputRenderer;

public abstract class GroupFilter
extends BasicFilter {
    private List<BasicFilter> initialFilters;
    private List<BasicFilter> filters;
    private List<BasicFilter> terminalFilters;
    private Object syncFilter = new Object();

    public GroupFilter() {
        this.initialFilters = new ArrayList<BasicFilter>();
        this.terminalFilters = new ArrayList<BasicFilter>();
        this.filters = new ArrayList<BasicFilter>();
    }

    @Override
    public synchronized void destroy() {
        super.destroy();
        for (BasicFilter basicFilter : this.filters) {
            basicFilter.destroy();
        }
    }

    @Override
    public void releaseFrameBuffer() {
        super.releaseFrameBuffer();
        for (BasicFilter basicFilter : this.filters) {
            basicFilter.releaseFrameBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        if (this.terminalFilters.contains(source)) {
            this.setWidth(source.getWidth());
            this.setHeight(source.getHeight());
            Object object = this.getLockObject();
            synchronized (object) {
                for (GLTextureInputRenderer gLTextureInputRenderer : this.getTargets()) {
                    gLTextureInputRenderer.newTextureReady(texture, this, newData);
                }
            }
        }
        Object object = this.getLockObject();
        synchronized (object) {
            Object object2 = this.syncFilter;
            synchronized (object2) {
                for (BasicFilter basicFilter : this.initialFilters) {
                    basicFilter.newTextureReady(texture, source, newData);
                }
            }
        }
    }

    protected synchronized void registerFilter(BasicFilter filter) {
        if (!this.filters.contains(filter)) {
            this.filters.add(filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void registerInitialFilter(BasicFilter filter) {
        Object object = this.syncFilter;
        synchronized (object) {
            this.initialFilters.add(filter);
            this.registerFilter(filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void removeInitialFilter(BasicFilter filter) {
        Object object = this.syncFilter;
        synchronized (object) {
            this.initialFilters.remove(filter);
            this.filters.remove(filter);
        }
    }

    protected synchronized void removeTerminalFilter(BasicFilter filter) {
        this.terminalFilters.remove(filter);
        this.filters.remove(filter);
    }

    protected synchronized void removeFilter(BasicFilter filter) {
        this.filters.remove(filter);
    }

    protected synchronized void registerTerminalFilter(BasicFilter filter) {
        this.terminalFilters.add(filter);
        this.registerFilter(filter);
    }

    @Override
    public void setRenderSize(int width, int height) {
        for (BasicFilter basicFilter : this.filters) {
            basicFilter.setRenderSize(width, height);
        }
    }

    public List<BasicFilter> getTerminalFilters() {
        return this.terminalFilters;
    }

    public List<BasicFilter> getInitialFilters() {
        return this.initialFilters;
    }
}

