/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter;

import android.graphics.PointF;
import android.opengl.GLES20;
import java.util.HashMap;
import java.util.Map;
import project.android.imageprocessing.filter.BasicFilter;

public class GenericFilter
extends BasicFilter {
    private String fragmentShader;
    private String vertexShader;
    private Map<String, Integer> uniformHandleList = new HashMap<String, Integer>();
    private Map<String, Integer> uniformIntList = new HashMap<String, Integer>();
    private Map<String, Float> uniformFloatList = new HashMap<String, Float>();
    private Map<String, PointF> uniformVec2List = new HashMap<String, PointF>();
    private Map<String, float[]> uniformVec3List = new HashMap<String, float[]>();
    private Map<String, float[]> uniformVec4List = new HashMap<String, float[]>();
    private Map<String, float[]> uniformMat3List = new HashMap<String, float[]>();
    private Map<String, float[]> uniformMat4List = new HashMap<String, float[]>();
    private Map<String, float[]> uniformFloatArrayList = new HashMap<String, float[]>();

    public GenericFilter() {
        this.setFragmentShader(super.getFragmentShader());
        this.setVertexShader(super.getVertexShader());
    }

    public void addUniformInteger(String name, int value) {
        if (!this.uniformIntList.containsKey(name)) {
            this.reInitialize();
        }
        this.uniformIntList.put(name, value);
    }

    public void addUniformFloat(String name, float value) {
        if (!this.uniformFloatList.containsKey(name)) {
            this.reInitialize();
        }
        this.uniformFloatList.put(name, Float.valueOf(value));
    }

    public void addUniformVec2(String name, PointF value) {
        if (!this.uniformVec2List.containsKey(name)) {
            this.reInitialize();
        }
        this.uniformVec2List.put(name, value);
    }

    public void addUniformVec3(String name, float[] value) {
        if (!this.uniformVec3List.containsKey(name)) {
            this.reInitialize();
        }
        this.uniformVec3List.put(name, value);
    }

    public void addUniformVec4(String name, float[] value) {
        if (!this.uniformVec4List.containsKey(name)) {
            this.reInitialize();
        }
        this.uniformVec4List.put(name, value);
    }

    public void addUniformMat3(String name, float[] value) {
        if (!this.uniformMat3List.containsKey(name)) {
            this.reInitialize();
        }
        this.uniformMat3List.put(name, value);
    }

    public void addUniformMat4(String name, float[] value) {
        if (!this.uniformMat4List.containsKey(name)) {
            this.reInitialize();
        }
        this.uniformMat4List.put(name, value);
    }

    public void addUniformFloatArray(String name, float[] value) {
        if (!this.uniformFloatArrayList.containsKey(name)) {
            this.reInitialize();
        }
        this.uniformFloatArrayList.put(name, value);
    }

    @Override
    protected String getFragmentShader() {
        return this.fragmentShader;
    }

    public void setFragmentShader(String fragmentShader) {
        this.fragmentShader = fragmentShader;
        this.reInitialize();
    }

    @Override
    protected String getVertexShader() {
        return this.vertexShader;
    }

    public void setVertexShader(String vertexShader) {
        this.vertexShader = vertexShader;
        this.reInitialize();
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        for (String string : this.uniformIntList.keySet()) {
            GLES20.glUniform1f((int)this.uniformHandleList.get(string), (float)this.uniformIntList.get(string).intValue());
        }
        for (String string : this.uniformFloatList.keySet()) {
            GLES20.glUniform1f((int)this.uniformHandleList.get(string), (float)this.uniformFloatList.get(string).floatValue());
        }
        for (String string : this.uniformVec2List.keySet()) {
            GLES20.glUniform2f((int)this.uniformHandleList.get(string), (float)this.uniformVec2List.get((Object)string).x, (float)this.uniformVec2List.get((Object)string).y);
        }
        for (String string : this.uniformVec3List.keySet()) {
            GLES20.glUniform3f((int)this.uniformHandleList.get(string), (float)this.uniformVec3List.get(string)[0], (float)this.uniformVec3List.get(string)[1], (float)this.uniformVec3List.get(string)[2]);
        }
        for (String string : this.uniformVec4List.keySet()) {
            GLES20.glUniform4f((int)this.uniformHandleList.get(string), (float)this.uniformVec4List.get(string)[0], (float)this.uniformVec4List.get(string)[1], (float)this.uniformVec4List.get(string)[2], (float)this.uniformVec4List.get(string)[3]);
        }
        for (String string : this.uniformMat3List.keySet()) {
            GLES20.glUniformMatrix3fv((int)this.uniformHandleList.get(string), (int)1, (boolean)false, (float[])this.uniformMat3List.get(string), (int)0);
        }
        for (String string : this.uniformMat4List.keySet()) {
            GLES20.glUniformMatrix4fv((int)this.uniformHandleList.get(string), (int)1, (boolean)false, (float[])this.uniformMat4List.get(string), (int)0);
        }
        for (String string : this.uniformFloatArrayList.keySet()) {
            GLES20.glUniform1fv((int)this.uniformHandleList.get(string), (int)this.uniformFloatArrayList.get(string).length, (float[])this.uniformFloatArrayList.get(string), (int)0);
        }
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        for (String string : this.uniformIntList.keySet()) {
            this.uniformHandleList.put(string, GLES20.glGetUniformLocation((int)this.programHandle, (String)string));
        }
        for (String string : this.uniformFloatList.keySet()) {
            this.uniformHandleList.put(string, GLES20.glGetUniformLocation((int)this.programHandle, (String)string));
        }
    }
}

