/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter;

import java.util.ArrayList;
import java.util.List;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.filter.MultiInputPixelFilter;
import project.android.imageprocessing.input.GLTextureOutputRenderer;

public abstract class CompositeMultiPixelFilter
extends MultiInputPixelFilter {
    private List<BasicFilter> initialFilters = new ArrayList<BasicFilter>();
    private List<GLTextureOutputRenderer> terminalFilters = new ArrayList<GLTextureOutputRenderer>();
    private List<GLTextureOutputRenderer> inputOutputFilters = new ArrayList<GLTextureOutputRenderer>();
    private List<GLTextureOutputRenderer> filters = new ArrayList<GLTextureOutputRenderer>();

    public CompositeMultiPixelFilter(int numOfInputs) {
        super(numOfInputs);
    }

    @Override
    public void destroy() {
        super.destroy();
        for (GLTextureOutputRenderer gLTextureOutputRenderer : this.filters) {
            gLTextureOutputRenderer.destroy();
        }
    }

    @Override
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        block5: {
            block4: {
                if (!this.inputOutputFilters.contains(source)) break block4;
                if (this.texturesReceived.contains(source)) break block5;
                super.newTextureReady(texture, source, newData);
                for (BasicFilter basicFilter : this.initialFilters) {
                    basicFilter.newTextureReady(texture, source, newData);
                }
                break block5;
            }
            if (this.terminalFilters.contains(source)) {
                super.newTextureReady(texture, source, newData);
            } else {
                for (BasicFilter basicFilter : this.initialFilters) {
                    basicFilter.newTextureReady(texture, source, newData);
                }
            }
        }
    }

    protected void registerFilter(GLTextureOutputRenderer filter) {
        if (!this.filters.contains(filter)) {
            this.filters.add(filter);
        }
    }

    protected void registerInitialFilter(BasicFilter filter) {
        this.initialFilters.add(filter);
        this.registerFilter(filter);
    }

    protected void registerInputOutputFilter(GLTextureOutputRenderer filter) {
        this.inputOutputFilters.add(filter);
        this.registerFilter(filter);
    }

    protected void registerTerminalFilter(GLTextureOutputRenderer filter) {
        this.terminalFilters.add(filter);
        this.registerFilter(filter);
    }

    @Override
    public void setRenderSize(int width, int height) {
        for (GLTextureOutputRenderer gLTextureOutputRenderer : this.filters) {
            gLTextureOutputRenderer.setRenderSize(width, height);
        }
        super.setRenderSize(width, height);
    }
}

