/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter;

import android.opengl.GLES20;
import project.android.imageprocessing.GLFrameBuffer;
import project.android.imageprocessing.filter.BasicFilter;

public abstract class CXTwoPassFilter
extends BasicFilter {
    protected GLFrameBuffer glFrameBufferFirst;
    protected int currentPass;

    @Override
    public void destroy() {
        super.destroy();
        if (null != this.glFrameBufferFirst) {
            this.glFrameBufferFirst.destoryBuffer();
            this.glFrameBufferFirst = null;
        }
    }

    @Override
    public void releaseFrameBuffer() {
        super.releaseFrameBuffer();
    }

    @Override
    protected void drawFrame() {
        this.currentPass = 1;
        if (this.glFrameBufferFirst == null) {
            if (this.getWidth() != 0 && this.getHeight() != 0) {
                this.initFBO();
            } else {
                return;
            }
        }
        if (this.glFrameBufferFirst != null && this.glFrameBufferFirst.getFrameBuffer() == null) {
            if (this.getWidth() != 0 && this.getHeight() != 0) {
                this.initFBO();
            } else {
                return;
            }
        }
        GLES20.glBindFramebuffer((int)36160, (int)this.glFrameBufferFirst.getFrameBuffer()[0]);
        if (this.texture_in == 0) {
            return;
        }
        this.drawSub();
        this.texture_in = this.glFrameBufferFirst.getTexture_out()[0];
        GLES20.glBindFramebuffer((int)36160, (int)0);
        this.currentPass = 2;
        super.drawFrame();
    }

    protected int getCurrentPass() {
        return this.currentPass;
    }

    @Override
    protected void initFBO() {
        super.initFBO();
        if (this.glFrameBufferFirst != null) {
            this.glFrameBufferFirst.destoryBuffer();
        }
        this.glFrameBufferFirst = new GLFrameBuffer(this.getWidth(), this.getHeight());
        this.glFrameBufferFirst.activityFrameBuffer(this.getWidth(), this.getHeight());
        int n = GLES20.glCheckFramebufferStatus((int)36160);
        if (n != 36053) {
            throw new RuntimeException(this + ": Failed to set up render buffer with status " + n + " and error " + GLES20.glGetError());
        }
    }
}

