/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter;

import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.input.GLTextureOutputRenderer;
import project.android.imageprocessing.inter.IEffectOptionsFilter;
import project.android.imageprocessing.model.FilterOptions;

public abstract class AbsEffectOptionFilter
extends BasicFilter
implements IEffectOptionsFilter {
    protected FilterOptions mOptions;
    private long duration = -1L;
    private long startTime = -1L;
    private IEffectOptionsFilter.RenderFinishListener renderFinishListener;

    @Override
    public void setFilterOptions(FilterOptions options) {
        this.mOptions = options;
    }

    @Override
    public FilterOptions getFilterOptions() {
        return this.mOptions;
    }

    @Override
    public void resetFilterOptions(FilterOptions options) {
        this.setFilterOptions(options);
    }

    @Override
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        super.newTextureReady(texture, source, newData);
        if (this.duration > -1L && this.startTime != -1L && System.currentTimeMillis() - this.startTime > this.duration && this.renderFinishListener != null) {
            this.renderFinishListener.onRenderFinish();
        }
        if (this.startTime == -1L) {
            this.startTime = System.currentTimeMillis();
        }
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getEscapedTime() {
        if (System.currentTimeMillis() - this.startTime >= this.duration) {
            return this.duration;
        }
        return System.currentTimeMillis() - this.startTime;
    }

    public void setRenderFinishListener(IEffectOptionsFilter.RenderFinishListener renderFinishListener) {
        this.renderFinishListener = renderFinishListener;
    }
}

