/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.ext;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.MultiInputFilter;

public class TriggerBlendFilter
extends MultiInputFilter {
    private static final String UNIFORM_BLEND = "blend";
    private int blendHandler;
    private boolean isBlend = true;
    private boolean disableBlendMode = false;

    public TriggerBlendFilter() {
        super(2);
    }

    public void setDisableBlendMode(boolean disableBlendMode) {
        this.disableBlendMode = disableBlendMode;
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.blendHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_BLEND);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform1f((int)this.blendHandler, (float)(this.isBlend ? 1.0f : 0.0f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlend(boolean blend) {
        Object object = this.listLock;
        synchronized (object) {
            this.isBlend = this.disableBlendMode ? true : blend;
        }
    }

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nuniform sampler2D inputImageTexture1;\nuniform float blend;\nvarying vec2 textureCoordinate;\nvoid main(){\n vec4 color2 = texture2D(inputImageTexture0,textureCoordinate);\n if(blend==0.0) {     gl_FragColor = color2; }  else{   vec4 color1 = texture2D(inputImageTexture1,textureCoordinate);\n   vec4 outputColor;\n   float a = color1.a + color2.a * (1.0 - color1.a);\n   outputColor.r = (color1.r * color1.a + color2.r * color2.a * (1.0 - color1.a))/a;\n   outputColor.g = (color1.g * color1.a + color2.g * color2.a * (1.0 - color1.a))/a;\n   outputColor.b = (color1.b * color1.a + color2.b * color2.a * (1.0 - color1.a))/a;\n   outputColor.a = 1.0;\n   gl_FragColor = outputColor;\n }}\n";
    }
}

