/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.ext;

import android.annotation.SuppressLint;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

@SuppressLint(value={"NewApi"})
public class SurfaceManager {
    public static final String TAG = "TextureManager";
    private static final int EGL_RECORDABLE_ANDROID = 12610;
    private static final int EGL_OPENGL_ES2_BIT = 4;
    int mSurfaceType = 0;
    int[] mDumpSurfaceAttribs = new int[]{12375, 640, 12374, 352, 12344};
    int[] surfaceAttribs = new int[]{12344};
    int[] attrib_list = new int[]{12440, 2, 12344};
    EGLConfig[] configs = new EGLConfig[1];
    int[] numConfigs = new int[1];
    int[] mPbattribList = new int[]{12324, 8, 12323, 8, 12322, 8, 12339, 1, 12352, 4, 12344};
    int[] recordattribList = new int[]{12324, 8, 12323, 8, 12322, 8, 12352, 4, 12610, 1, 12344};
    private EGLContext mEGLContext = EGL10.EGL_NO_CONTEXT;
    private EGLContext mEGLSharedContext = EGL10.EGL_NO_CONTEXT;
    private EGLSurface mEGLSurface = EGL10.EGL_NO_SURFACE;
    private EGLSurface mEGLDumpSurface = EGL10.EGL_NO_SURFACE;
    private EGLDisplay mEGLDisplay = EGL10.EGL_NO_DISPLAY;
    private EGL10 mEGL = null;
    private Object mSurface;
    private int[] mScreenWidth = new int[1];
    private int[] mScreenHight = new int[1];

    public SurfaceManager(Object surface, SurfaceManager manager, Object o) {
        this.mSurface = surface;
        this.mEGLSharedContext = manager.mEGLContext;
        this.mSurfaceType = 0;
        this.eglSetup();
    }

    public SurfaceManager(Object surface, int surfaceType, EGLContext SharedContext, Object o) {
        this.mSurface = surface;
        this.mEGLSharedContext = SharedContext;
        this.mSurfaceType = surfaceType;
        this.eglSetup();
    }

    public SurfaceManager(Object surface) {
        this.mSurface = surface;
        this.mSurfaceType = 0;
        this.eglSetup();
    }

    public void makeCurrent() {
        if (this.mEGLSurface != EGL10.EGL_NO_SURFACE) {
            this.mEGL.eglMakeCurrent(this.mEGLDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, this.mEGLContext);
            if (!this.mEGL.eglMakeCurrent(this.mEGLDisplay, this.mEGLSurface, this.mEGLSurface, this.mEGLContext)) {
                // empty if block
            }
        }
        if (this.mEGLDumpSurface == EGL10.EGL_NO_SURFACE || !this.mEGL.eglMakeCurrent(this.mEGLDisplay, this.mEGLDumpSurface, this.mEGLDumpSurface, this.mEGLContext)) {
            // empty if block
        }
    }

    public void swapBuffer() {
        if (this.mEGLSurface != EGL10.EGL_NO_SURFACE) {
            this.mEGL.eglSwapBuffers(this.mEGLDisplay, this.mEGLSurface);
        }
    }

    public void setPresentationTime(long nsecs) {
        this.checkEglError("eglPresentationTimeANDROID");
    }

    private void eglSetup() {
        try {
            if (this.mEGL == null) {
                this.mEGL = (EGL10)EGLContext.getEGL();
            }
            this.mEGLDisplay = this.mEGL.eglGetDisplay((Object)0);
            if (this.mEGLDisplay == EGL10.EGL_NO_DISPLAY) {
                return;
            }
            int[] nArray = new int[2];
            if (!this.mEGL.eglInitialize(this.mEGLDisplay, null)) {
                return;
            }
            if (this.mSurfaceType != 2) {
                this.mEGL.eglChooseConfig(this.mEGLDisplay, this.mPbattribList, this.configs, 1, this.numConfigs);
            } else {
                this.mEGL.eglChooseConfig(this.mEGLDisplay, this.recordattribList, this.configs, 1, this.numConfigs);
            }
            this.checkEglError("eglCreateContext RGB888+recordable ES2");
            this.mEGLContext = this.mEGLSharedContext == null ? this.mEGL.eglCreateContext(this.mEGLDisplay, this.configs[0], EGL10.EGL_NO_CONTEXT, this.attrib_list) : this.mEGL.eglCreateContext(this.mEGLDisplay, this.configs[0], this.mEGLSharedContext, this.attrib_list);
            this.checkEglError("eglCreateContext");
            if (this.mSurface != null) {
                this.mEGLSurface = this.mEGL.eglCreateWindowSurface(this.mEGLDisplay, this.configs[0], this.mSurface, this.surfaceAttribs);
                this.checkEglError("eglCreateWindowSurface");
                this.mEGL.eglQuerySurface(this.mEGLDisplay, this.mEGLSurface, 12374, this.mScreenHight);
                this.mEGL.eglQuerySurface(this.mEGLDisplay, this.mEGLSurface, 12375, this.mScreenWidth);
            } else if (this.mSurfaceType == 0 && this.mEGLDumpSurface == EGL10.EGL_NO_SURFACE) {
                this.mEGLDumpSurface = this.mEGL.eglCreatePbufferSurface(this.mEGLDisplay, this.configs[0], this.mDumpSurfaceAttribs);
                this.checkEglError("eglCreatePbufferSurface");
                if (this.mEGLDumpSurface == EGL10.EGL_NO_SURFACE) {
                    return;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void release() {
        if (this.mEGLDisplay != EGL10.EGL_NO_DISPLAY) {
            this.mEGL.eglMakeCurrent(this.mEGLDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
            this.mEGL.eglDestroySurface(this.mEGLDisplay, this.mEGLSurface);
            this.mEGL.eglDestroyContext(this.mEGLDisplay, this.mEGLContext);
            this.mEGL.eglTerminate(this.mEGLDisplay);
        }
        this.mEGLDisplay = EGL10.EGL_NO_DISPLAY;
        this.mEGLContext = EGL10.EGL_NO_CONTEXT;
        this.mEGLDumpSurface = this.mEGLSurface = EGL10.EGL_NO_SURFACE;
    }

    private void checkEglError(String msg) {
        int n;
        if (this.mEGL == null || (n = this.mEGL.eglGetError()) != 12288) {
            // empty if block
        }
    }
}

