/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.ext;

import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import project.android.imageprocessing.GLFrameBuffer;
import project.android.imageprocessing.input.GLTextureOutputRenderer;

public class MMTextureResourceInput
extends GLTextureOutputRenderer {
    private static final String TAG = MMTextureResourceInput.class.getName();
    private static final String UNIFORM_CAM_MATRIX = "u_Matrix";
    private int matrixHandle;
    public SurfaceTexture mText = null;
    protected int updateText = 0;
    private int mHeightOutput = 0;
    private int mWidthOutput = 0;
    protected boolean mSizeChanged = false;
    private boolean mIsOES = true;
    private Bitmap mBitmap = null;
    private int mBitmapWidth = -1;
    private int mBitmapHeight = -1;
    private int mTextureIDBitmap = 0;
    private SurfaceTexture mSurfaceTextureBitmap = null;
    private int[] mTextureTex = null;
    protected int textureHandle1;
    private int mOESLocation;
    private float mOES = 1.0f;
    public static final String UNIFORM_TEXTURE1 = "inputImageTexture1";
    private int mDisplayMode = 1;
    private int mInputWidth = 0;
    private int mInputHeight = 0;
    public static final float[] identityMatrix = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    public static final int FLIP_VERTICAL = 0;
    public static final int FLIP_HORIZONTAL = 1;
    public static final int FLIP_BOTH = 2;
    public static final int FLIP_NONE = 3;

    public MMTextureResourceInput() {
        this.textureVertices = new FloatBuffer[4];
        float[] fArray = new float[]{0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f};
        this.textureVertices[0] = ByteBuffer.allocateDirect(fArray.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.textureVertices[0].put(fArray).position(0);
        float[] fArray2 = new float[]{1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
        this.textureVertices[1] = ByteBuffer.allocateDirect(fArray2.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.textureVertices[1].put(fArray2).position(0);
        float[] fArray3 = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f};
        this.textureVertices[2] = ByteBuffer.allocateDirect(fArray3.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.textureVertices[2].put(fArray3).position(0);
        float[] fArray4 = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
        this.textureVertices[3] = ByteBuffer.allocateDirect(fArray4.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.textureVertices[3].put(fArray4).position(0);
        this.mTextureIDBitmap = 0;
        this.mSurfaceTextureBitmap = null;
        this.mIsOES = true;
        this.mBitmap = null;
    }

    public void changeCurRotation(int rotation) {
        this.curRotation = 0;
        this.rotateClockwise90Degrees(rotation / 90);
    }

    public void flipPosition(int flipDirection) {
        if (flipDirection == 3) {
            this.setRenderVertices(new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f});
            this.textureVertices = new FloatBuffer[4];
            float[] fArray = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
            this.textureVertices[0] = ByteBuffer.allocateDirect(fArray.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            this.textureVertices[0].put(fArray).position(0);
            float[] fArray2 = new float[]{0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f};
            this.textureVertices[1] = ByteBuffer.allocateDirect(fArray2.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            this.textureVertices[1].put(fArray2).position(0);
            float[] fArray3 = new float[]{1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f};
            this.textureVertices[2] = ByteBuffer.allocateDirect(fArray3.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            this.textureVertices[2].put(fArray3).position(0);
            float[] fArray4 = new float[]{1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
            this.textureVertices[3] = ByteBuffer.allocateDirect(fArray4.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            this.textureVertices[3].put(fArray4).position(0);
            return;
        }
        float f = 0.0f;
        float f2 = 1.0f;
        float f3 = 0.0f;
        float f4 = 1.0f;
        switch (flipDirection) {
            case 0: {
                f = 1.0f;
                f2 = 0.0f;
                break;
            }
            case 1: {
                f3 = 1.0f;
                f4 = 0.0f;
                break;
            }
            case 2: {
                f = 1.0f;
                f2 = 0.0f;
                f3 = 1.0f;
                f4 = 0.0f;
            }
        }
        float[] fArray = new float[]{f, f3, f2, f3, f, f4, f2, f4};
        this.textureVertices[0] = ByteBuffer.allocateDirect(fArray.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.textureVertices[0].put(fArray).position(0);
        float[] fArray5 = new float[]{f3, f2, f3, f, f4, f2, f4, f};
        this.textureVertices[1] = ByteBuffer.allocateDirect(fArray5.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.textureVertices[1].put(fArray5).position(0);
        float[] fArray6 = new float[]{f2, f4, f, f4, f2, f3, f, f3};
        this.textureVertices[2] = ByteBuffer.allocateDirect(fArray6.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.textureVertices[2].put(fArray6).position(0);
        float[] fArray7 = new float[]{f4, f, f4, f2, f3, f, f3, f2};
        this.textureVertices[3] = ByteBuffer.allocateDirect(fArray7.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.textureVertices[3].put(fArray7).position(0);
    }

    @Override
    public void setRenderSize(int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        if (width != this.mWidthOutput || height != this.mHeightOutput) {
            this.mSizeChanged = true;
            this.mHeightOutput = height;
            this.mWidthOutput = width;
        }
        if (this.mSizeChanged) {
            super.setRenderSize(width, height);
        }
    }

    public void drawImageFrame() {
        this.drawFrame();
    }

    @Override
    public void drawFrame() {
        if (this.mText != null && this.updateText == 1) {
            try {
                this.mText.updateTexImage();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            this.updateText = 0;
        }
        if (this.mSizeChanged) {
            this.handleSizeChange();
            this.mSizeChanged = false;
        }
        super.drawFrame();
    }

    @Override
    public void destroy() {
        super.destroy();
        if (null != this.mText) {
            this.mText.release();
        }
        if (this.texture_in != 0) {
            int[] nArray = new int[]{this.texture_in};
            GLES20.glDeleteTextures((int)1, (int[])nArray, (int)0);
        }
        if (this.mSurfaceTextureBitmap != null) {
            this.mSurfaceTextureBitmap.release();
            this.mSurfaceTextureBitmap = null;
        }
        this.mText = null;
        this.mTextureIDBitmap = 0;
        this.mSurfaceTextureBitmap = null;
        this.mIsOES = true;
        this.mBitmap = null;
    }

    @Override
    public void releaseFrameBuffer() {
        super.releaseFrameBuffer();
        if (this.texture_in != 0) {
            int[] nArray = new int[]{this.texture_in};
            GLES20.glDeleteTextures((int)1, (int[])nArray, (int)0);
        }
        this.mText = null;
        this.mIsOES = true;
        this.mBitmap = null;
    }

    public void loadTexture(int textId, SurfaceTexture text) {
        if (this.mIsOES) {
            this.texture_in = textId;
            this.mText = text;
            this.updateText = 1;
            this.markAsDirty();
        }
    }

    private int bitmapToTexture(Bitmap bitmap) {
        if (this.mTextureTex != null) {
            GLES20.glDeleteTextures((int)1, (int[])this.mTextureTex, (int)0);
            this.mTextureTex = null;
        }
        this.mTextureTex = new int[1];
        GLES20.glGenTextures((int)1, (int[])this.mTextureTex, (int)0);
        GLES20.glBindTexture((int)3553, (int)this.mTextureTex[0]);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
        GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
        if (bitmap != null && !bitmap.isRecycled()) {
            GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
        }
        return this.mTextureTex[0];
    }

    public static void updateBitmap(Bitmap bitmap, int textid) {
        GLES20.glBindTexture((int)3553, (int)textid);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
        GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
        if (bitmap != null && !bitmap.isRecycled()) {
            GLUtils.texSubImage2D((int)3553, (int)0, (int)0, (int)0, (Bitmap)bitmap);
        }
    }

    public void loadTexture(Bitmap bitmap) {
        if (!this.mIsOES) {
            if (bitmap != null && !bitmap.isRecycled()) {
                if (this.mTextureIDBitmap == 0 || this.mSurfaceTextureBitmap == null) {
                    this.mBitmapWidth = bitmap.getWidth();
                    this.mBitmapHeight = bitmap.getHeight();
                    this.setRenderSize(this.mBitmapWidth, this.mBitmapHeight);
                    this.mTextureIDBitmap = this.bitmapToTexture(bitmap);
                    if (this.mTextureIDBitmap > 0) {
                        this.mSurfaceTextureBitmap = new SurfaceTexture(this.mTextureIDBitmap);
                        bitmap.recycle();
                    }
                } else {
                    int n = bitmap.getHeight();
                    int n2 = bitmap.getWidth();
                    if (n != this.mBitmapHeight || n2 != this.mBitmapWidth) {
                        this.mBitmapWidth = n2;
                        this.mBitmapHeight = n;
                        this.setRenderSize(this.mBitmapWidth, this.mBitmapHeight);
                        this.mTextureIDBitmap = 0;
                        if (this.mSurfaceTextureBitmap != null) {
                            this.mSurfaceTextureBitmap.release();
                            this.mSurfaceTextureBitmap = null;
                        }
                        this.mTextureIDBitmap = this.bitmapToTexture(bitmap);
                        this.mSurfaceTextureBitmap = new SurfaceTexture(this.mTextureIDBitmap);
                    } else {
                        MMTextureResourceInput.updateBitmap(bitmap, this.mTextureIDBitmap);
                    }
                    bitmap.recycle();
                }
            }
            this.texture_in = this.mTextureIDBitmap;
            this.mText = this.mSurfaceTextureBitmap;
            if (this.mText == null) {
                return;
            }
            this.updateText = 1;
            this.markAsDirty();
        }
    }

    public int getBitmapTextureID() {
        return this.mTextureIDBitmap;
    }

    public SurfaceTexture getBitmapSurfaceTexture() {
        return this.mSurfaceTextureBitmap;
    }

    private void bindTexture() {
        GLES20.glActiveTexture((int)33984);
        if (this.mIsOES) {
            GLES20.glBindTexture((int)36197, (int)this.texture_in);
        } else {
            GLES20.glActiveTexture((int)33985);
            GLES20.glBindTexture((int)3553, (int)this.texture_in);
        }
    }

    @Override
    protected void passShaderValues() {
        this.renderVertices.position(0);
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.renderVertices);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle);
        this.textureVertices[this.curRotation].position(0);
        GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.textureVertices[this.curRotation]);
        GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
        if (this.mIsOES) {
            GLES20.glUniform1f((int)this.mOESLocation, (float)1.0f);
        } else {
            GLES20.glUniform1f((int)this.mOESLocation, (float)0.0f);
        }
        this.bindTexture();
        GLES20.glUniform1i((int)this.textureHandle, (int)0);
        GLES20.glUniform1i((int)this.textureHandle1, (int)1);
        GLES20.glUniformMatrix4fv((int)this.matrixHandle, (int)1, (boolean)false, (float[])identityMatrix, (int)0);
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.matrixHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_CAM_MATRIX);
        this.textureHandle1 = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_TEXTURE1);
        this.mOESLocation = GLES20.glGetUniformLocation((int)this.programHandle, (String)"oesFlag");
    }

    @Override
    public void initWithGLContext() {
        super.initWithGLContext();
    }

    public void updateYUVBuffer(ByteBuffer yByteBuffer, ByteBuffer uvByteBufer) {
    }

    public void setOESMode(boolean isOES) {
        if (this.mIsOES != isOES) {
            // empty if block
        }
        this.mIsOES = isOES;
    }

    @Override
    protected void initFBO() {
        if (null != this.glFrameBuffer) {
            this.glFrameBuffer.destoryBuffer();
        }
        this.glFrameBuffer = new GLFrameBuffer(this.getWidth(), this.getHeight());
        this.glFrameBuffer.activityFrameBuffer(this.getWidth(), this.getHeight());
        int n = GLES20.glCheckFramebufferStatus((int)36160);
        if (n != 36053) {
            throw new RuntimeException(this + ": Failed to set up render buffer with status " + n + " and error " + GLES20.glGetError());
        }
        if (this.mSizeChanged) {
            this.mSizeChanged = false;
        }
    }

    @Override
    protected String getFragmentShader() {
        return "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nuniform samplerExternalOES inputImageTexture0;\nuniform sampler2D inputImageTexture1;\nvarying vec2 textureCoordinate;\nvarying float oes_flag; \nvoid main() {\nif (oes_flag ==1.0) {   gl_FragColor = texture2D(inputImageTexture0, textureCoordinate);\n} else { \ngl_FragColor = texture2D(inputImageTexture1, textureCoordinate);} \n}\n";
    }

    @Override
    protected String getVertexShader() {
        return "uniform mat4 u_Matrix;\nattribute vec4 position;\nattribute vec2 inputTextureCoordinate;\nvarying vec2 textureCoordinate;\nuniform float oesFlag; \nvarying float oes_flag; \nvoid main() {\n   oes_flag = oesFlag; \n   vec4 texPos = u_Matrix * vec4(inputTextureCoordinate, 1, 1);\n   textureCoordinate = texPos.xy;\n   gl_Position = position;\n}\n";
    }

    @Override
    public void setDisplayMode(int width, int height, int type) {
        if (this.mDisplayMode != type || this.mInputHeight != height || this.mInputWidth != width) {
            this.mDisplayMode = type;
            this.mInputHeight = height;
            this.mInputWidth = width;
            super.setDisplayMode(width, height, type);
        }
    }
}

