/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.ext;

import android.opengl.GLES20;
import java.nio.Buffer;
import project.android.imageprocessing.GLFrameBuffer;
import project.android.imageprocessing.ext.GLProcessingPipeline;
import project.android.imageprocessing.input.GLTextureOutputRenderer;
import project.android.imageprocessing.output.GLTextureInputRenderer;

public class GLZoomTextureFilter
extends GLTextureOutputRenderer
implements GLTextureInputRenderer {
    private GLProcessingPipeline rendererContext;
    public boolean mEnabled = false;
    private float sourceWidth;
    private float sourceHeight;
    private int mImageWidthFactorLocation;
    private int mImageHeightFactorLocation;

    public int getTexture() {
        return this.glFrameBuffer.getTexture_out()[0];
    }

    @Override
    protected String getVertexShader() {
        return "attribute vec4 position;\nattribute vec2 inputTextureCoordinate;\nvarying vec2 textureCoordinate;\nuniform float imageWidthFactor; \nuniform float imageHeightFactor; \nvarying vec2 lefttopCoordinate;\nvarying vec2 rightbottomCoordinate; \nvarying vec2 righttopCoordinate;\nvarying vec2 leftbottomCoordinate;\nvoid main() {\n  textureCoordinate = inputTextureCoordinate;\nvec2 widthStep = vec2(imageWidthFactor, -imageHeightFactor);\nvec2 heightStep = vec2(imageWidthFactor, imageHeightFactor);\nlefttopCoordinate = inputTextureCoordinate.xy - widthStep;\nrightbottomCoordinate = inputTextureCoordinate.xy + widthStep;\nrighttopCoordinate = inputTextureCoordinate.xy + heightStep;\nleftbottomCoordinate = inputTextureCoordinate.xy - heightStep;\ngl_Position = position;\n}\n";
    }

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nvarying vec2 lefttopCoordinate;\nvarying vec2 rightbottomCoordinate; \nvarying vec2 righttopCoordinate;\nvarying vec2 leftbottomCoordinate;\nvoid main(){\nvec4 center = texture2D(inputImageTexture0,textureCoordinate); \nvec4 lt=texture2D(inputImageTexture0, clamp(lefttopCoordinate, 0.0, 1.0)); \nvec4 lb=texture2D(inputImageTexture0, clamp(leftbottomCoordinate, 0.0, 1.0)); \nvec4 rt=texture2D(inputImageTexture0, clamp(righttopCoordinate, 0.0, 1.0)); \nvec4 rb=texture2D(inputImageTexture0, clamp(rightbottomCoordinate, 0.0, 1.0)); \nvec4 l=texture2D(inputImageTexture0, clamp(vec2(lefttopCoordinate.x,textureCoordinate.y), 0.0, 1.0)); \nvec4 r=texture2D(inputImageTexture0, clamp(vec2(righttopCoordinate.x,textureCoordinate.y), 0.0, 1.0)); \nvec4 t=texture2D(inputImageTexture0, clamp(vec2(textureCoordinate.x, lefttopCoordinate.y), 0.0, 1.0)); \nvec4 b=texture2D(inputImageTexture0, clamp(vec2(textureCoordinate.x, rightbottomCoordinate.y), 0.0, 1.0)); \ngl_FragColor = clamp((center+lt+lb+rt+rb+l+t+b+r)/9.0, 0.0, 1.0); \n}\n";
    }

    @Override
    protected void initShaderHandles() {
        this.textureHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"inputImageTexture0");
        this.positionHandle = GLES20.glGetAttribLocation((int)this.programHandle, (String)"position");
        this.texCoordHandle = GLES20.glGetAttribLocation((int)this.programHandle, (String)"inputTextureCoordinate");
        this.mImageWidthFactorLocation = GLES20.glGetUniformLocation((int)this.programHandle, (String)"imageWidthFactor");
        this.mImageHeightFactorLocation = GLES20.glGetUniformLocation((int)this.programHandle, (String)"imageHeightFactor");
    }

    @Override
    protected void passShaderValues() {
        this.renderVertices.position(0);
        GLES20.glUniform1f((int)this.mImageHeightFactorLocation, (float)(1.0f / this.sourceWidth));
        GLES20.glUniform1f((int)this.mImageWidthFactorLocation, (float)(1.0f / this.sourceHeight));
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.renderVertices);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle);
        this.textureVertices[this.curRotation].position(0);
        GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.textureVertices[this.curRotation]);
        GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.texture_in);
        GLES20.glUniform1i((int)this.textureHandle, (int)0);
    }

    @Override
    protected void initWithGLContext() {
        super.initWithGLContext();
    }

    @Override
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        if (newData) {
            this.markAsDirty();
        }
        this.texture_in = texture;
        this.sourceWidth = source.getWidth();
        this.sourceHeight = source.getHeight();
        this.setWidth(source.getWidth());
        this.setHeight(source.getHeight());
        this.onDrawFrame();
        source.unlockRenderBuffer();
    }

    private void drawIndeed() {
        if (this.texture_in == 0) {
            return;
        }
        GLES20.glViewport((int)0, (int)0, (int)this.getWidth(), (int)this.getHeight());
        GLES20.glUseProgram((int)this.programHandle);
        GLES20.glClear((int)16640);
        GLES20.glClearColor((float)this.getBackgroundRed(), (float)this.getBackgroundGreen(), (float)this.getBackgroundBlue(), (float)this.getBackgroundAlpha());
        this.passShaderValues();
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void drawFrame() {
        if (this.glFrameBuffer == null) {
            if (this.getWidth() != 0 && this.getHeight() != 0) {
                this.initFBO();
            } else {
                return;
            }
        }
        boolean bl = false;
        if (this.glFrameBuffer != null && this.glFrameBuffer.getFrameBuffer() == null) {
            if (this.getWidth() != 0 && this.getHeight() != 0) {
                this.initFBO();
            } else {
                return;
            }
        }
        if (this.dirty) {
            bl = true;
            GLES20.glBindFramebuffer((int)36160, (int)this.glFrameBuffer.getFrameBuffer()[0]);
            this.drawIndeed();
            GLES20.glBindFramebuffer((int)36160, (int)0);
        }
        Object object = this.listLock;
        synchronized (object) {
            for (GLTextureInputRenderer gLTextureInputRenderer : this.targets) {
                gLTextureInputRenderer.newTextureReady(this.glFrameBuffer.getTexture_out()[0], this, bl);
            }
        }
    }

    @Override
    protected void initFBO() {
        if (null != this.glFrameBuffer) {
            this.glFrameBuffer.destoryBuffer();
        }
        this.glFrameBuffer = new GLFrameBuffer(this.getWidth(), this.getHeight());
        this.glFrameBuffer.activityFrameBuffer(this.getWidth(), this.getHeight());
        int n = GLES20.glCheckFramebufferStatus((int)36160);
        if (n != 36053) {
            throw new RuntimeException(this + ": Failed to set up render buffer with status " + n + " and error " + GLES20.glGetError());
        }
    }
}

