/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.ext;

import java.util.ArrayList;
import java.util.List;
import project.android.imageprocessing.GLRenderer;

public class GLProcessingPipeline {
    private boolean rendering = false;
    private List<GLRenderer> rootRenderers;
    private List<GLRenderer> filtersToDestroy = new ArrayList<GLRenderer>();
    private int width;
    private int height;
    private int textInId;

    public GLProcessingPipeline() {
        this.rootRenderers = new ArrayList<GLRenderer>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilterToDestroy(GLRenderer renderer) {
        List<GLRenderer> list = this.filtersToDestroy;
        synchronized (list) {
            this.filtersToDestroy.add(renderer);
        }
    }

    public synchronized void addRootRenderer(GLRenderer rootRenderer) {
        this.rootRenderers.add(rootRenderer);
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    private synchronized boolean isRendering() {
        return this.rendering;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDrawFrame() {
        if (this.isRendering()) {
            for (int i = 0; i < this.rootRenderers.size(); ++i) {
                GLRenderer gLRenderer;
                GLProcessingPipeline object = this;
                synchronized (object) {
                    gLRenderer = this.rootRenderers.get(i);
                }
                gLRenderer.onDrawFrame();
            }
        }
        List<GLRenderer> list = this.filtersToDestroy;
        synchronized (list) {
            for (GLRenderer gLRenderer : this.filtersToDestroy) {
                gLRenderer.destroy();
            }
            this.filtersToDestroy.clear();
        }
    }

    public void destroy() {
        for (GLRenderer gLRenderer : this.rootRenderers) {
            gLRenderer.destroy();
        }
        this.rootRenderers.clear();
        for (GLRenderer gLRenderer : this.filtersToDestroy) {
            gLRenderer.destroy();
        }
        this.filtersToDestroy.clear();
    }

    public void changeSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public synchronized void pauseRendering() {
        this.rendering = false;
    }

    public synchronized void removeRootRenderer(GLRenderer rootRenderer) {
        this.rootRenderers.remove(rootRenderer);
    }

    public synchronized void startRendering() {
        if (this.rootRenderers.size() != 0) {
            this.rendering = true;
        }
    }

    public synchronized void setTextInId(int textInId) {
        this.textInId = textInId;
    }
}

