/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.ext;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.input.GLTextureOutputRenderer;

public class GLOnScreenEndpoint
extends BasicFilter {
    private float zoomScale = 1.0f;
    private float sourceWidth;
    private float sourceHeight;
    private float hScalRatio = 1.0f;
    private float wScalRatio = 1.0f;
    private boolean needDropFirstFrame = false;
    private FloatBuffer textureCoordBuffer = null;

    @Override
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        if (this.curRotation % 2 == 1) {
            this.sourceWidth = source.getHeight();
            this.sourceHeight = source.getWidth();
        } else {
            this.sourceWidth = source.getWidth();
            this.sourceHeight = source.getHeight();
        }
        super.newTextureReady(texture, source, newData);
    }

    @Override
    protected void passShaderValues() {
        this.renderVertices.position(0);
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.renderVertices);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle);
        this.textureCoordBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.textureCoordBuffer);
        GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.texture_in);
        GLES20.glUniform1i((int)this.textureHandle, (int)0);
    }

    @Override
    protected void handleSizeChange() {
        float[] fArray = new float[8];
        this.textureVertices[this.curRotation].position(0);
        this.textureVertices[this.curRotation].get(fArray);
        this.wScalRatio = (float)this.getWidth() * 1.0f / this.sourceWidth;
        this.hScalRatio = (float)this.getHeight() * 1.0f / this.sourceHeight;
        float f = (1.0f - this.hScalRatio) / 2.0f;
        float f2 = (1.0f - this.wScalRatio) / 2.0f;
        this.textureCoordBuffer = ByteBuffer.allocateDirect(fArray.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        if (this.curRotation % 2 != 0) {
            for (int i = 0; i < 4; ++i) {
                float f3 = fArray[i * 2];
                fArray[i * 2] = (double)f3 < 0.5 ? f3 + f : f3 - f;
                f3 = fArray[i * 2 + 1];
                fArray[i * 2 + 1] = (double)f3 < 0.5 ? f3 + f2 : f3 - f2;
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                float f4 = fArray[i * 2];
                fArray[i * 2] = (double)f4 < 0.5 ? f4 + f2 : f4 - f2;
                f4 = fArray[i * 2 + 1];
                fArray[i * 2 + 1] = (double)f4 < 0.5 ? f4 + f : f4 - f;
            }
        }
        this.textureCoordBuffer.position(0);
        this.textureCoordBuffer.put(fArray);
        this.textureCoordBuffer.position(0);
    }

    @Override
    protected void drawFrame() {
        if (this.texture_in == 0) {
            return;
        }
        if (this.needDropFirstFrame) {
            this.needDropFirstFrame = false;
            return;
        }
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLES20.glViewport((int)0, (int)0, (int)((int)(this.zoomScale * (float)this.getWidth())), (int)((int)(this.zoomScale * (float)this.getHeight())));
        GLES20.glUseProgram((int)this.programHandle);
        GLES20.glClearColor((float)this.getBackgroundRed(), (float)this.getBackgroundGreen(), (float)this.getBackgroundBlue(), (float)this.getBackgroundAlpha());
        this.passShaderValues();
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        this.disableDrawArray();
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    public Bitmap snapPicture(int degress) {
        GLES20.glBindFramebuffer((int)36160, (int)0);
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (n2 > 0 && n > 0) {
            IntBuffer intBuffer = IntBuffer.allocate(n * n2);
            GLES20.glReadPixels((int)0, (int)0, (int)n, (int)n2, (int)6408, (int)5121, (Buffer)intBuffer);
            Bitmap bitmap = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.copyPixelsFromBuffer((Buffer)intBuffer);
            Matrix matrix = new Matrix();
            matrix.postScale(1.0f, -1.0f);
            matrix.postRotate((float)degress);
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)n, (int)n2, (Matrix)matrix, (boolean)true);
            return bitmap;
        }
        return null;
    }

    public void setNeedDropFirstFrame(boolean needDropFirstFrame) {
        this.needDropFirstFrame = needDropFirstFrame;
    }
}

