/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.ext;

import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import project.android.imageprocessing.GLFrameBuffer;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.input.GLTextureOutputRenderer;
import project.android.imageprocessing.output.GLTextureInputRenderer;

public class GLCutZoomTextureFilter
extends BasicFilter {
    private static final String TAG = "zoomFilter";
    public static final int DISPLAY_NORMAL = 0;
    public static final int DISPLAY_CENTER = 1;
    public static final int SCREEN_ORIENTATION_LANDSCAPE = 2;
    public static final int SCREEN_ORIENTATION_PORTRAIT = 1;
    public static final int SCREEN_ORIENTATION_AUTO = 3;
    public static final int SMOOTH_NONE = 0;
    public static final int SMOOTH_MEAN = 1;
    public static final int SMOOTH_GAUSS = 2;
    public static final float SMOOTH_THRESHOLD = 0.5f;
    private float inputScale = 1.3333334f;
    private float sourceWidth;
    private float sourceHeight;
    private int mDisplayPos = 0;
    private boolean mDisplayPosIncreasing = true;
    private int mSmoothMode = 0;
    private int mOutputScreenOrient = 1;
    private int mImageWidthStepLocation;
    private int mImageHeightStepLocation;
    private int mImagePartialDisplayLocation;
    private int mImageSmoothLocation;
    private FloatBuffer[] textureVerticesCut;
    private float[] texData0;
    private float[] texData1;
    private float[] texData2;
    private float[] texData3;
    private boolean isSetTextureVertices = false;
    private int mDisplayMode = 0;

    public void setDisplayMode(int mDisplayMode) {
        this.mDisplayMode = mDisplayMode;
    }

    public int getTexture() {
        return this.glFrameBuffer.getTexture_out()[0];
    }

    @Override
    protected String getFragmentShader() {
        if (this.mDisplayMode == 1) {
            return super.getFragmentShader();
        }
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nvarying vec2 xy_step;\nvarying float pos; \nvarying float smooth; \nvoid main(){\nvec2 point = textureCoordinate; \nvec4 image_c = texture2D(inputImageTexture0,point); \nvec4 image = image_c;\nif (smooth >= 0.1) { \nvec4 image_lt=texture2D(inputImageTexture0, clamp(point+vec2(-xy_step.x,  xy_step.y), 0.0, 1.0)); \nvec4 image_lb=texture2D(inputImageTexture0, clamp(point+vec2(-xy_step.x, -xy_step.y), 0.0, 1.0)); \nvec4 image_rt=texture2D(inputImageTexture0, clamp(point+vec2( xy_step.x,  xy_step.y), 0.0, 1.0)); \nvec4 image_rb=texture2D(inputImageTexture0, clamp(point+vec2( xy_step.x, -xy_step.y), 0.0, 1.0)); \nvec4 image_l =texture2D(inputImageTexture0, clamp(point+vec2(-xy_step.x,     0.0), 0.0, 1.0)); \nvec4 image_r =texture2D(inputImageTexture0, clamp(point+vec2( xy_step.x,     0.0), 0.0, 1.0)); \nvec4 image_t =texture2D(inputImageTexture0, clamp(point+vec2(    0.0,  xy_step.y), 0.0, 1.0)); \nvec4 image_b =texture2D(inputImageTexture0, clamp(point+vec2(    0.0, -xy_step.y), 0.0, 1.0)); \nimage = clamp(image_c*0.25+(image_lt+image_lb+image_rt+image_rb)*0.125+(image_l+image_t+image_b+image_r)*0.0625, 0.0, 1.0); \n} \ngl_FragColor = image;\n}\n";
    }

    @Override
    protected String getVertexShader() {
        if (this.mDisplayMode == 1) {
            return super.getVertexShader();
        }
        return "attribute vec4 position;\nattribute vec2 inputTextureCoordinate;\nvarying vec2 textureCoordinate;\nuniform float widthStep; \nuniform float heightStep; \nuniform float displayPos; \nuniform float smoothMode; \nvarying float smooth; \nvarying float pos; \nvarying vec2 xy_step;\nvoid main() {\npos = displayPos; \nsmooth = smoothMode; \n  textureCoordinate = inputTextureCoordinate;\nxy_step = vec2(widthStep, heightStep);\ngl_Position = position;\n}\n";
    }

    @Override
    protected void initShaderHandles() {
        if (this.mDisplayMode == 1) {
            super.initShaderHandles();
            return;
        }
        this.textureHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"inputImageTexture0");
        this.positionHandle = GLES20.glGetAttribLocation((int)this.programHandle, (String)"position");
        this.texCoordHandle = GLES20.glGetAttribLocation((int)this.programHandle, (String)"inputTextureCoordinate");
        this.mImageWidthStepLocation = GLES20.glGetUniformLocation((int)this.programHandle, (String)"widthStep");
        this.mImageHeightStepLocation = GLES20.glGetUniformLocation((int)this.programHandle, (String)"heightStep");
        this.mImagePartialDisplayLocation = GLES20.glGetUniformLocation((int)this.programHandle, (String)"displayPos");
        this.mImageSmoothLocation = GLES20.glGetUniformLocation((int)this.programHandle, (String)"smoothMode");
    }

    private void setCutTextureCord(float left, float right, float top, float bottom) {
        if (!this.isSetTextureVertices) {
            this.textureVerticesCut = new FloatBuffer[4];
            this.texData0 = new float[8];
            this.texData1 = new float[8];
            this.texData2 = new float[8];
            this.texData3 = new float[8];
            this.isSetTextureVertices = true;
        }
        if (this.isSetTextureVertices) {
            this.texData0[0] = left;
            this.texData0[1] = top;
            this.texData0[2] = right;
            this.texData0[3] = top;
            this.texData0[4] = left;
            this.texData0[5] = bottom;
            this.texData0[6] = right;
            this.texData0[7] = bottom;
            this.textureVerticesCut[0] = ByteBuffer.allocateDirect(this.texData0.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            this.textureVerticesCut[0].put(this.texData0).position(0);
            this.texData1[0] = left;
            this.texData1[1] = bottom;
            this.texData1[2] = left;
            this.texData1[3] = top;
            this.texData1[4] = right;
            this.texData1[5] = bottom;
            this.texData1[6] = right;
            this.texData1[7] = top;
            this.textureVerticesCut[1] = ByteBuffer.allocateDirect(this.texData1.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            this.textureVerticesCut[1].put(this.texData1).position(0);
            this.texData2[0] = right;
            this.texData2[1] = bottom;
            this.texData2[2] = left;
            this.texData2[3] = bottom;
            this.texData2[4] = right;
            this.texData2[5] = top;
            this.texData2[6] = left;
            this.texData2[7] = top;
            this.textureVerticesCut[2] = ByteBuffer.allocateDirect(this.texData2.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            this.textureVerticesCut[2].put(this.texData2).position(0);
            this.texData3[0] = right;
            this.texData3[1] = top;
            this.texData3[2] = right;
            this.texData3[3] = bottom;
            this.texData3[4] = left;
            this.texData3[5] = top;
            this.texData3[6] = left;
            this.texData3[7] = bottom;
            this.textureVerticesCut[3] = ByteBuffer.allocateDirect(this.texData3.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            this.textureVerticesCut[3].put(this.texData3).position(0);
        }
    }

    @Override
    protected void passShaderValues() {
        if (this.mDisplayMode == 1) {
            super.passShaderValues();
            return;
        }
        int n = this.curRotation;
        this.renderVertices.position(0);
        this.mDisplayPos = this.mDisplayPosIncreasing ? ++this.mDisplayPos : --this.mDisplayPos;
        if (this.mDisplayPos >= (int)this.sourceWidth) {
            this.mDisplayPosIncreasing = false;
        } else if (this.mDisplayPos <= 0) {
            this.mDisplayPosIncreasing = true;
        }
        float f = 1.0f / this.sourceWidth;
        float f2 = 1.0f / this.sourceHeight;
        GLES20.glUniform1f((int)this.mImageWidthStepLocation, (float)f);
        GLES20.glUniform1f((int)this.mImageHeightStepLocation, (float)f2);
        GLES20.glUniform1f((int)this.mImagePartialDisplayLocation, (float)(1.0f * (float)this.mDisplayPos / this.sourceWidth));
        GLES20.glUniform1f((int)this.mImageSmoothLocation, (float)((float)this.mSmoothMode / 10.0f));
        if (this.mOutputScreenOrient == 1) {
            n += 0;
        } else if (this.mOutputScreenOrient == 2) {
            ++n;
        }
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.renderVertices);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle);
        this.textureVerticesCut[n %= 4].position(0);
        GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.textureVerticesCut[n]);
        GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.texture_in);
        GLES20.glUniform1i((int)this.textureHandle, (int)0);
    }

    @Override
    protected void initWithGLContext() {
        super.initWithGLContext();
    }

    public float getInputScale() {
        return this.inputScale;
    }

    public void setInputScale(float inputScale) {
        this.inputScale = inputScale;
    }

    @Override
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        if (newData) {
            this.markAsDirty();
        }
        this.texture_in = texture;
        this.sourceWidth = source.getWidth();
        this.sourceHeight = source.getHeight();
        this.inputScale = this.sourceHeight / (this.sourceWidth * 1.0f);
        this.onDrawFrame();
        source.unlockRenderBuffer();
    }

    public void setOutputScreenOrient(int screenOrient) {
        this.mOutputScreenOrient = screenOrient;
    }

    private void drawCut(float outputScale) {
        int n = (int)(this.sourceHeight / outputScale);
        int n2 = (int)(this.sourceWidth * outputScale);
        if ((float)n < this.sourceWidth) {
            float f;
            float f2 = f = (this.sourceWidth - (float)n) * 0.5f / this.sourceWidth;
            float f3 = 1.0f - f;
            float f4 = 0.0f;
            float f5 = 1.0f;
            this.setCutTextureCord(f2, f3, f4, f5);
        } else {
            float f = (this.sourceHeight - (float)n2) * 0.5f / this.sourceHeight;
            float f6 = 0.0f;
            float f7 = 1.0f;
            float f8 = f;
            float f9 = 1.0f - f;
            this.setCutTextureCord(f6, f7, f8, f9);
        }
    }

    private void checkZoomIn(int dstWidth, int dstHeight) {
        float f = (float)dstWidth * 1.0f / this.sourceWidth;
        float f2 = (float)dstHeight * 1.0f / this.sourceHeight;
        if (f <= 0.5f && f2 <= 0.5f) {
            if (this.mSmoothMode != 2) {
                // empty if block
            }
            this.mSmoothMode = 2;
        } else {
            if (this.mSmoothMode != 0) {
                // empty if block
            }
            this.mSmoothMode = 0;
        }
    }

    private void drawIndeed() {
        if (this.texture_in == 0) {
            return;
        }
        if (this.mOutputScreenOrient == 1) {
            this.checkZoomIn(this.getWidth(), this.getHeight());
            if ((float)this.getHeight() * 1.0f / (float)this.getWidth() != this.inputScale) {
                float f = (float)this.getHeight() * 1.0f / (float)this.getWidth();
                this.drawCut(f);
            } else {
                float f = (float)this.getHeight() * 1.0f / (float)this.getWidth();
                this.drawCut(f);
            }
        } else if (this.mOutputScreenOrient == 2) {
            this.checkZoomIn(this.getHeight(), this.getWidth());
            if ((float)this.getWidth() * 1.0f / (float)this.getHeight() != this.inputScale) {
                float f = (float)this.getWidth() * 1.0f / (float)this.getHeight();
                this.drawCut(f);
            } else {
                float f = (float)this.getHeight() * 1.0f / (float)this.getWidth();
                this.drawCut(f);
            }
        }
        GLES20.glViewport((int)0, (int)0, (int)this.getWidth(), (int)this.getHeight());
        GLES20.glUseProgram((int)this.programHandle);
        GLES20.glClear((int)16640);
        GLES20.glClearColor((float)this.getBackgroundRed(), (float)this.getBackgroundGreen(), (float)this.getBackgroundBlue(), (float)this.getBackgroundAlpha());
        this.passShaderValues();
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        this.disableDrawArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void drawFrame() {
        if (this.glFrameBuffer == null) {
            if (this.getWidth() != 0 && this.getHeight() != 0) {
                this.initFBO();
            } else {
                return;
            }
        }
        boolean bl = false;
        if (this.glFrameBuffer != null && this.glFrameBuffer.getFrameBuffer() == null) {
            if (this.getWidth() != 0 && this.getHeight() != 0) {
                this.initFBO();
            } else {
                return;
            }
        }
        if (this.dirty) {
            bl = true;
            GLES20.glBindFramebuffer((int)36160, (int)this.glFrameBuffer.getFrameBuffer()[0]);
            if (this.mDisplayMode == 0) {
                this.drawIndeed();
            } else {
                this.drawCenterMode();
            }
            GLES20.glBindFramebuffer((int)36160, (int)0);
        }
        Object object = this.listLock;
        synchronized (object) {
            for (GLTextureInputRenderer gLTextureInputRenderer : this.targets) {
                gLTextureInputRenderer.newTextureReady(this.glFrameBuffer.getTexture_out()[0], this, bl);
            }
        }
    }

    private void drawCenterMode() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = this.getWidth();
        int n6 = this.getHeight();
        int n7 = (int)((float)n6 * (1.0f * this.sourceWidth / this.sourceHeight));
        int n8 = (int)((float)n5 * (1.0f * this.sourceHeight / this.sourceWidth));
        if (n7 < n5) {
            n4 = (n5 - n7) / 2;
            n3 = 0;
            n2 = n7;
            n = n6;
        } else if (n8 < n6) {
            n4 = 0;
            n3 = (n6 - n8) / 2;
            n2 = n5;
            n = n8;
        } else {
            n4 = 0;
            n3 = 0;
            n2 = n5;
            n = n6;
        }
        GLES20.glViewport((int)n4, (int)n3, (int)(n2 + 1), (int)n);
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GLES20.glClear((int)16640);
        GLES20.glUseProgram((int)this.programHandle);
        this.passShaderValues();
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        this.disableDrawArray();
    }

    @Override
    protected void initFBO() {
        if (null != this.glFrameBuffer) {
            this.glFrameBuffer.destoryBuffer();
        }
        this.glFrameBuffer = new GLFrameBuffer(this.getWidth(), this.getHeight());
        this.glFrameBuffer.activityFrameBuffer(this.getWidth(), this.getHeight());
        int n = GLES20.glCheckFramebufferStatus((int)36160);
        if (n != 36053) {
            throw new RuntimeException(this + ": Failed to set up render buffer with status " + n + " and error " + GLES20.glGetError());
        }
    }
}

