/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.ext;

import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import project.android.imageprocessing.GLFrameBuffer;
import project.android.imageprocessing.ext.GLProcessingPipeline;
import project.android.imageprocessing.input.GLTextureOutputRenderer;
import project.android.imageprocessing.output.GLTextureInputRenderer;

public class GLCutTextureFilter
extends GLTextureOutputRenderer
implements GLTextureInputRenderer {
    private GLProcessingPipeline rendererContext;
    private float inputScale = 1.3333334f;
    private float sourceWidth;
    private float sourceHeight;
    private int mLowerLimit = 0;
    private int mUpperLimit = 0;
    private FloatBuffer[] textureVerticesCut;
    private float[] texData0;
    private float[] texData1;
    private float[] texData2;
    private float[] texData3;
    private boolean isSetTextureVertices = false;
    private int mRightEdgeLocation;

    @Override
    protected String getVertexShader() {
        return "attribute vec4 position;\nattribute vec2 inputTextureCoordinate;\nvarying vec2 textureCoordinate;\nuniform float rightEdge; \nvarying float right_edge; \nvoid main() {\nright_edge = rightEdge; \n  textureCoordinate = inputTextureCoordinate;\n   gl_Position = position;\n}\n";
    }

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nvarying float right_edge; \nvoid main(){\nif (textureCoordinate.x < right_edge) \ngl_FragColor = texture2D(inputImageTexture0,textureCoordinate);\nelse {\nvec2 xy = vec2(textureCoordinate.x-(1.0-right_edge), textureCoordinate.y); \ngl_FragColor = texture2D(inputImageTexture0,xy);\n} \n}\n";
    }

    @Override
    protected void initShaderHandles() {
        this.textureHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"inputImageTexture0");
        this.positionHandle = GLES20.glGetAttribLocation((int)this.programHandle, (String)"position");
        this.texCoordHandle = GLES20.glGetAttribLocation((int)this.programHandle, (String)"inputTextureCoordinate");
        this.mRightEdgeLocation = GLES20.glGetUniformLocation((int)this.programHandle, (String)"rightEdge");
    }

    public void setCutRange(int lowerLimit, int upperLimit) {
        this.mLowerLimit = lowerLimit;
        this.mUpperLimit = upperLimit;
    }

    @Override
    protected void initWithGLContext() {
        super.initWithGLContext();
    }

    public float getInputScale() {
        return this.inputScale;
    }

    public void setInputScale(float inputScale) {
        this.inputScale = inputScale;
    }

    @Override
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        if (newData) {
            this.markAsDirty();
        }
        this.texture_in = texture;
        this.sourceWidth = source.getWidth();
        this.sourceHeight = source.getHeight();
        this.inputScale = this.sourceHeight / (this.sourceWidth * 1.0f);
        this.setWidth(source.getWidth());
        this.setHeight(source.getHeight());
        this.onDrawFrame();
        source.unlockRenderBuffer();
    }

    private void setCutTextureCord(float left, float right, float top, float bottom) {
        if (!this.isSetTextureVertices) {
            this.textureVerticesCut = new FloatBuffer[4];
            this.texData0 = new float[8];
            this.texData1 = new float[8];
            this.texData2 = new float[8];
            this.texData3 = new float[8];
            this.isSetTextureVertices = true;
        }
        if (this.isSetTextureVertices) {
            this.texData0[0] = left;
            this.texData0[1] = top;
            this.texData0[2] = right;
            this.texData0[3] = top;
            this.texData0[4] = left;
            this.texData0[5] = bottom;
            this.texData0[6] = right;
            this.texData0[7] = bottom;
            this.textureVerticesCut[0] = ByteBuffer.allocateDirect(this.texData0.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            this.textureVerticesCut[0].put(this.texData0).position(0);
            this.texData1[0] = left;
            this.texData1[1] = bottom;
            this.texData1[2] = left;
            this.texData1[3] = top;
            this.texData1[4] = right;
            this.texData1[5] = bottom;
            this.texData1[6] = right;
            this.texData1[7] = top;
            this.textureVerticesCut[1] = ByteBuffer.allocateDirect(this.texData1.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            this.textureVerticesCut[1].put(this.texData1).position(0);
            this.texData2[0] = right;
            this.texData2[1] = bottom;
            this.texData2[2] = left;
            this.texData2[3] = bottom;
            this.texData2[4] = right;
            this.texData2[5] = top;
            this.texData2[6] = left;
            this.texData2[7] = top;
            this.textureVerticesCut[2] = ByteBuffer.allocateDirect(this.texData2.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            this.textureVerticesCut[2].put(this.texData2).position(0);
            this.texData3[0] = right;
            this.texData3[1] = top;
            this.texData3[2] = right;
            this.texData3[3] = bottom;
            this.texData3[4] = left;
            this.texData3[5] = top;
            this.texData3[6] = left;
            this.texData3[7] = bottom;
            this.textureVerticesCut[3] = ByteBuffer.allocateDirect(this.texData3.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            this.textureVerticesCut[3].put(this.texData3).position(0);
        }
    }

    @Override
    protected void passShaderValues() {
        this.renderVertices.position(0);
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.renderVertices);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle);
        if (this.mLowerLimit == 0 && this.mUpperLimit == 0) {
            GLES20.glUniform1f((int)this.mRightEdgeLocation, (float)1.0f);
            this.textureVertices[this.curRotation].position(0);
            GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.textureVertices[this.curRotation]);
        } else {
            GLES20.glUniform1f((int)this.mRightEdgeLocation, (float)(1.0f - 1.0f / this.sourceWidth));
            this.setCutTextureCord(0.0f, 1.0f, 1.0f * (float)this.mLowerLimit / this.sourceHeight, 1.0f * (float)this.mUpperLimit / this.sourceHeight);
            this.textureVerticesCut[this.curRotation].position(0);
            GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.textureVerticesCut[this.curRotation]);
        }
        GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.texture_in);
        GLES20.glUniform1i((int)this.textureHandle, (int)0);
    }

    private void drawIndeed() {
        if (this.texture_in == 0) {
            return;
        }
        if (this.mLowerLimit == 0 && this.mUpperLimit == 0 && (float)this.getHeight() * 1.0f / (float)this.getWidth() != this.inputScale) {
            int n = this.getWidth();
            int n2 = (int)this.sourceWidth;
            int n3 = ((int)this.sourceHeight - this.getHeight()) / 2;
            int n4 = ((int)this.sourceWidth - this.getWidth()) / 2;
            GLES20.glViewport((int)(-n4), (int)(-n3), (int)((int)this.sourceWidth), (int)((int)this.sourceHeight));
        } else {
            GLES20.glViewport((int)0, (int)0, (int)this.getWidth(), (int)this.getHeight());
        }
        GLES20.glUseProgram((int)this.programHandle);
        GLES20.glClearColor((float)this.getBackgroundRed(), (float)this.getBackgroundGreen(), (float)this.getBackgroundBlue(), (float)this.getBackgroundAlpha());
        GLES20.glClear((int)16640);
        this.passShaderValues();
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void drawFrame() {
        if (this.glFrameBuffer == null) {
            if (this.getWidth() != 0 && this.getHeight() != 0) {
                this.initFBO();
            } else {
                return;
            }
        }
        boolean bl = false;
        if (this.glFrameBuffer != null && this.glFrameBuffer.getFrameBuffer() == null) {
            if (this.getWidth() != 0 && this.getHeight() != 0) {
                this.initFBO();
            } else {
                return;
            }
        }
        if (this.dirty) {
            bl = true;
            GLES20.glBindFramebuffer((int)36160, (int)this.glFrameBuffer.getFrameBuffer()[0]);
            this.drawIndeed();
            GLES20.glBindFramebuffer((int)36160, (int)0);
        }
        Object object = this.listLock;
        synchronized (object) {
            for (GLTextureInputRenderer gLTextureInputRenderer : this.targets) {
                gLTextureInputRenderer.newTextureReady(this.glFrameBuffer.getTexture_out()[0], this, bl);
            }
        }
    }

    @Override
    protected void initFBO() {
        if (null != this.glFrameBuffer) {
            this.glFrameBuffer.destoryBuffer();
        }
        this.glFrameBuffer = new GLFrameBuffer(this.getWidth(), this.getHeight());
        this.glFrameBuffer.activityFrameBuffer(this.getWidth(), this.getHeight());
        int n = GLES20.glCheckFramebufferStatus((int)36160);
        if (n != 36053) {
            throw new RuntimeException(this + ": Failed to set up render buffer with status " + n + " and error " + GLES20.glGetError());
        }
    }
}

