/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing;

import android.graphics.Point;
import android.opengl.Matrix;

public class RendererCommon {
    private static float BALANCED_VISIBLE_FRACTION = 0.5625f;

    public static final float[] identityMatrix() {
        return new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    }

    public static final float[] verticalFlipMatrix() {
        return new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f};
    }

    public static final float[] horizontalFlipMatrix() {
        return new float[]{-1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f};
    }

    public static float[] rotateTextureMatrix(float[] textureMatrix, float rotationDegree) {
        float[] fArray = new float[16];
        Matrix.setRotateM((float[])fArray, (int)0, (float)rotationDegree, (float)0.0f, (float)0.0f, (float)1.0f);
        RendererCommon.adjustOrigin(fArray);
        return RendererCommon.multiplyMatrices(textureMatrix, fArray);
    }

    public static float[] multiplyMatrices(float[] a2, float[] b) {
        float[] fArray = new float[16];
        Matrix.multiplyMM((float[])fArray, (int)0, (float[])a2, (int)0, (float[])b, (int)0);
        return fArray;
    }

    public static float[] getLayoutMatrix(boolean mirror, float videoAspectRatio, float displayAspectRatio) {
        float f = 1.0f;
        float f2 = 1.0f;
        if (displayAspectRatio > videoAspectRatio) {
            f2 = videoAspectRatio / displayAspectRatio;
        } else {
            f = displayAspectRatio / videoAspectRatio;
        }
        if (mirror) {
            f *= -1.0f;
        }
        float[] fArray = new float[16];
        Matrix.setIdentityM((float[])fArray, (int)0);
        Matrix.scaleM((float[])fArray, (int)0, (float)f, (float)f2, (float)1.0f);
        RendererCommon.adjustOrigin(fArray);
        return fArray;
    }

    public static Point getDisplaySize(a scalingType, float videoAspectRatio, int maxDisplayWidth, int maxDisplayHeight) {
        return RendererCommon.getDisplaySize(RendererCommon.convertScalingTypeToVisibleFraction(scalingType), videoAspectRatio, maxDisplayWidth, maxDisplayHeight);
    }

    private static void adjustOrigin(float[] matrix) {
        matrix[12] = matrix[12] - 0.5f * (matrix[0] + matrix[4]);
        matrix[13] = matrix[13] - 0.5f * (matrix[1] + matrix[5]);
        matrix[12] = matrix[12] + 0.5f;
        matrix[13] = matrix[13] + 0.5f;
    }

    private static float convertScalingTypeToVisibleFraction(a scalingType) {
        switch (scalingType) {
            case SCALE_ASPECT_FIT: {
                return 1.0f;
            }
            case SCALE_ASPECT_FILL: {
                return 0.0f;
            }
            case SCALE_ASPECT_BALANCED: {
                return BALANCED_VISIBLE_FRACTION;
            }
        }
        throw new IllegalArgumentException();
    }

    private static Point getDisplaySize(float minVisibleFraction, float videoAspectRatio, int maxDisplayWidth, int maxDisplayHeight) {
        if (minVisibleFraction == 0.0f || videoAspectRatio == 0.0f) {
            return new Point(maxDisplayWidth, maxDisplayHeight);
        }
        int n = Math.min(maxDisplayWidth, Math.round((float)maxDisplayHeight / minVisibleFraction * videoAspectRatio));
        int n2 = Math.min(maxDisplayHeight, Math.round((float)maxDisplayWidth / minVisibleFraction / videoAspectRatio));
        return new Point(n, n2);
    }

    public static enum a {
        SCALE_ASPECT_FIT,
        SCALE_ASPECT_FILL,
        SCALE_ASPECT_BALANCED;

    }
}

