/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing;

import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public abstract class GLRenderer {
    public static final String ATTRIBUTE_POSITION = "position";
    public static final String ATTRIBUTE_TEXCOORD = "inputTextureCoordinate";
    public static final String VARYING_TEXCOORD = "textureCoordinate";
    protected static final String UNIFORM_TEXTUREBASE = "inputImageTexture";
    public static final String UNIFORM_TEXTURE0 = "inputImageTexture0";
    protected int curRotation;
    protected FloatBuffer renderVertices;
    public FloatBuffer[] textureVertices;
    protected int programHandle;
    protected int textureHandle;
    protected int positionHandle;
    protected int texCoordHandle;
    protected int texture_in;
    protected boolean useNewViewPort = false;
    private int vertexShaderHandle;
    private int fragmentShaderHandle;
    protected int width;
    protected int height;
    private boolean customSizeSet;
    private boolean initialized = false;
    private boolean sizeChanged;
    private float red;
    private float green;
    private float blue;
    private float alpha;
    protected int mDisplayMode = 1;
    private int mInputWidth = 0;
    private int mInputHeight = 0;

    public GLRenderer() {
        this.setRenderVertices(new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f});
        this.textureVertices = new FloatBuffer[4];
        float[] fArray = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
        this.textureVertices[0] = ByteBuffer.allocateDirect(fArray.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.textureVertices[0].put(fArray).position(0);
        float[] fArray2 = new float[]{0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f};
        this.textureVertices[1] = ByteBuffer.allocateDirect(fArray2.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.textureVertices[1].put(fArray2).position(0);
        float[] fArray3 = new float[]{1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f};
        this.textureVertices[2] = ByteBuffer.allocateDirect(fArray3.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.textureVertices[2].put(fArray3).position(0);
        float[] fArray4 = new float[]{1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        this.textureVertices[3] = ByteBuffer.allocateDirect(fArray4.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.textureVertices[3].put(fArray4).position(0);
        this.curRotation = 0;
        this.texture_in = 0;
        this.customSizeSet = false;
        this.initialized = false;
        this.sizeChanged = false;
        this.mDisplayMode = 1;
    }

    protected void setRenderVertices(float[] vertices) {
        this.renderVertices = ByteBuffer.allocateDirect(vertices.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.renderVertices.put(vertices).position(0);
    }

    public int getWidth() {
        return this.width;
    }

    protected void setWidth(int width) {
        if (!this.customSizeSet && this.width != width) {
            this.width = width;
            this.sizeChanged = true;
        }
    }

    public int getHeight() {
        return this.height;
    }

    protected void setHeight(int height) {
        if (!this.customSizeSet && this.height != height) {
            this.height = height;
            this.sizeChanged = true;
        }
    }

    public void rotateClockwise90Degrees(int numOfTimes) {
        this.curRotation += numOfTimes;
        this.curRotation %= 4;
        if (numOfTimes % 2 == 1) {
            int n = this.width;
            this.width = this.height;
            this.height = n;
        }
    }

    public void rotateCounterClockwise90Degrees(int numOfTimes) {
        this.curRotation += 4 - numOfTimes % 4;
        this.curRotation %= 4;
        if (numOfTimes % 2 == 1) {
            int n = this.width;
            this.width = this.height;
            this.height = n;
        }
    }

    public void resetClockDegrees() {
        if (this.curRotation == 1 || this.curRotation == 3) {
            int n = this.width;
            this.width = this.height;
            this.height = n;
        }
        this.curRotation = 0;
    }

    public void setRenderSize(int width, int height) {
        int n;
        int n2;
        if (this.curRotation % 2 == 1) {
            n2 = height;
            n = width;
        } else {
            n2 = width;
            n = height;
        }
        if (!this.customSizeSet || this.width != n2 || this.height != n) {
            this.sizeChanged = true;
        }
        this.width = n2;
        this.height = n;
        this.customSizeSet = true;
    }

    protected void passShaderValues() {
        this.renderVertices.position(0);
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.renderVertices);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle);
        this.textureVertices[this.curRotation].position(0);
        GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.textureVertices[this.curRotation]);
        GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.texture_in);
        GLES20.glUniform1i((int)this.textureHandle, (int)0);
    }

    protected void disableDrawArray() {
        GLES20.glDisableVertexAttribArray((int)this.positionHandle);
        GLES20.glDisableVertexAttribArray((int)this.texCoordHandle);
        GLES20.glBindTexture((int)3553, (int)0);
    }

    protected void bindShaderAttributes() {
        GLES20.glBindAttribLocation((int)this.programHandle, (int)0, (String)ATTRIBUTE_POSITION);
        GLES20.glBindAttribLocation((int)this.programHandle, (int)1, (String)ATTRIBUTE_TEXCOORD);
    }

    protected void initShaderHandles() {
        this.textureHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_TEXTURE0);
        this.positionHandle = GLES20.glGetAttribLocation((int)this.programHandle, (String)ATTRIBUTE_POSITION);
        this.texCoordHandle = GLES20.glGetAttribLocation((int)this.programHandle, (String)ATTRIBUTE_TEXCOORD);
    }

    public void reInitialize() {
        this.initialized = false;
    }

    public void onDrawFrame() {
        if (!this.initialized) {
            this.initWithGLContext();
            this.initialized = true;
        }
        if (this.sizeChanged) {
            this.handleSizeChange();
            this.sizeChanged = false;
        }
        this.drawFrame();
    }

    public void destroy() {
        this.initialized = false;
        if (this.programHandle != 0) {
            GLES20.glDeleteProgram((int)this.programHandle);
            this.programHandle = 0;
        }
        if (this.vertexShaderHandle != 0) {
            GLES20.glDeleteShader((int)this.vertexShaderHandle);
            this.vertexShaderHandle = 0;
        }
        if (this.fragmentShaderHandle != 0) {
            GLES20.glDeleteShader((int)this.fragmentShaderHandle);
            this.fragmentShaderHandle = 0;
        }
    }

    protected void initWithGLContext() {
        int[] nArray;
        String string = this.getVertexShader();
        String string2 = this.getFragmentShader();
        this.vertexShaderHandle = GLES20.glCreateShader((int)35633);
        String string3 = "none";
        if (this.vertexShaderHandle != 0) {
            GLES20.glShaderSource((int)this.vertexShaderHandle, (String)string);
            GLES20.glCompileShader((int)this.vertexShaderHandle);
            nArray = new int[1];
            GLES20.glGetShaderiv((int)this.vertexShaderHandle, (int)35713, (int[])nArray, (int)0);
            if (nArray[0] == 0) {
                string3 = GLES20.glGetShaderInfoLog((int)this.vertexShaderHandle);
                GLES20.glDeleteShader((int)this.vertexShaderHandle);
                this.vertexShaderHandle = 0;
            }
        }
        if (this.vertexShaderHandle == 0) {
            throw new RuntimeException(this + ": Could not create vertex shader. Reason: " + string3);
        }
        this.fragmentShaderHandle = GLES20.glCreateShader((int)35632);
        if (this.fragmentShaderHandle != 0) {
            GLES20.glShaderSource((int)this.fragmentShaderHandle, (String)string2);
            GLES20.glCompileShader((int)this.fragmentShaderHandle);
            nArray = new int[1];
            GLES20.glGetShaderiv((int)this.fragmentShaderHandle, (int)35713, (int[])nArray, (int)0);
            if (nArray[0] == 0) {
                string3 = GLES20.glGetShaderInfoLog((int)this.fragmentShaderHandle);
                GLES20.glDeleteShader((int)this.fragmentShaderHandle);
                this.fragmentShaderHandle = 0;
            }
        }
        if (this.fragmentShaderHandle == 0) {
            throw new RuntimeException(this + ": Could not create fragment shader. Reason: " + string3);
        }
        this.programHandle = GLES20.glCreateProgram();
        if (this.programHandle != 0) {
            GLES20.glAttachShader((int)this.programHandle, (int)this.vertexShaderHandle);
            GLES20.glAttachShader((int)this.programHandle, (int)this.fragmentShaderHandle);
            this.bindShaderAttributes();
            GLES20.glLinkProgram((int)this.programHandle);
            nArray = new int[1];
            GLES20.glGetProgramiv((int)this.programHandle, (int)35714, (int[])nArray, (int)0);
            if (nArray[0] == 0) {
                GLES20.glDeleteProgram((int)this.programHandle);
                this.programHandle = 0;
            }
        }
        if (this.programHandle == 0) {
            throw new RuntimeException("Could not create program.");
        }
        this.initShaderHandles();
    }

    protected void handleSizeChange() {
    }

    protected void drawFrame() {
        if (this.mDisplayMode == 1) {
            GLES20.glViewport((int)0, (int)0, (int)this.width, (int)this.height);
            GLES20.glClearColor((float)this.getBackgroundRed(), (float)this.getBackgroundGreen(), (float)this.getBackgroundBlue(), (float)this.getBackgroundAlpha());
            GLES20.glClear((int)16640);
        } else {
            int n;
            int n2;
            int n3;
            int n4;
            int n5 = (int)((float)this.height * (1.0f * (float)this.mInputWidth / (float)this.mInputHeight));
            int n6 = (int)((float)this.width * (1.0f * (float)this.mInputHeight / (float)this.mInputWidth));
            if (n5 < this.width) {
                n4 = (this.width - n5) / 2;
                n3 = 0;
                n2 = n5;
                n = this.height;
            } else if (n6 < this.height) {
                n4 = 0;
                n3 = (this.height - n6) / 2;
                n2 = this.width;
                n = n6;
            } else {
                n4 = 0;
                n3 = 0;
                n2 = this.width;
                n = this.height;
            }
            GLES20.glViewport((int)n4, (int)n3, (int)(n2 + 1), (int)n);
            GLES20.glClearColor((float)this.getBackgroundRed(), (float)this.getBackgroundGreen(), (float)this.getBackgroundBlue(), (float)this.getBackgroundAlpha());
            GLES20.glClear((int)16640);
        }
        GLES20.glUseProgram((int)this.programHandle);
        this.passShaderValues();
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        this.disableDrawArray();
    }

    protected String getVertexShader() {
        return "attribute vec4 position;\nattribute vec2 inputTextureCoordinate;\nvarying vec2 textureCoordinate;\nvoid main() {\n  textureCoordinate = inputTextureCoordinate;\n   gl_Position = position;\n}\n";
    }

    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nvoid main(){\n   gl_FragColor = texture2D(inputImageTexture0,textureCoordinate);\n}\n";
    }

    public void setBackgroundColour(float red, float green, float blue, float alpha) {
        this.setBackgroundRed(red);
        this.setBackgroundGreen(green);
        this.setBackgroundBlue(blue);
        this.setBackgroundAlpha(alpha);
    }

    public float getBackgroundRed() {
        return this.red;
    }

    public void setBackgroundRed(float red) {
        this.red = red;
    }

    public float getBackgroundGreen() {
        return this.green;
    }

    public void setBackgroundGreen(float green) {
        this.green = green;
    }

    public float getBackgroundBlue() {
        return this.blue;
    }

    public void setBackgroundBlue(float blue) {
        this.blue = blue;
    }

    public float getBackgroundAlpha() {
        return this.alpha;
    }

    public void setBackgroundAlpha(float alpha) {
        this.alpha = alpha;
    }

    public void setDisplayMode(int width, int height, int type) {
        this.mDisplayMode = type;
        this.mInputHeight = height;
        this.mInputWidth = width;
    }

    public void releaseFrameBuffer() {
        this.initialized = false;
        if (this.programHandle != 0) {
            GLES20.glDeleteProgram((int)this.programHandle);
            this.programHandle = 0;
        }
        if (this.vertexShaderHandle != 0) {
            GLES20.glDeleteShader((int)this.vertexShaderHandle);
            this.vertexShaderHandle = 0;
        }
        if (this.fragmentShaderHandle != 0) {
            GLES20.glDeleteShader((int)this.fragmentShaderHandle);
            this.fragmentShaderHandle = 0;
        }
    }
}

