/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing;

import java.util.HashMap;
import project.android.imageprocessing.GLFrameBuffer;

public class GLRenderBufferCache {
    private static HashMap<String, GLFrameBuffer> bufferHashMap;
    private static GLRenderBufferCache ourInstance;

    private GLRenderBufferCache() {
        bufferHashMap = new HashMap();
    }

    public static GLRenderBufferCache getInstance() {
        return ourInstance;
    }

    public synchronized GLFrameBuffer getFrameBufferBySize(int width, int height) {
        String string = width + "_" + height;
        GLFrameBuffer gLFrameBuffer = bufferHashMap.get(string);
        if (gLFrameBuffer == null || gLFrameBuffer.isLocked) {
            gLFrameBuffer = new GLFrameBuffer(width, height);
            bufferHashMap.put(string, gLFrameBuffer);
        }
        return gLFrameBuffer;
    }

    public synchronized void removeFrameBufferBySize(int width, int height) {
        String string = width + "_" + height;
        GLFrameBuffer gLFrameBuffer = bufferHashMap.get(string);
        if (gLFrameBuffer != null) {
            bufferHashMap.remove(string);
            gLFrameBuffer = null;
        }
    }

    static {
        ourInstance = new GLRenderBufferCache();
    }
}

