/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing;

import android.opengl.GLSurfaceView;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;
import project.android.imageprocessing.GLRenderer;

public class FastImageProcessingPipeline
implements GLSurfaceView.Renderer {
    private boolean rendering = false;
    private List<GLRenderer> rootRenderers;
    private List<GLRenderer> filtersToDestroy = new ArrayList<GLRenderer>();
    private int width;
    private int height;
    private final Queue<Runnable> mRunOnDraw;
    private final Queue<Runnable> mRunOnDrawEnd;

    public FastImageProcessingPipeline() {
        this.rootRenderers = new ArrayList<GLRenderer>();
        this.mRunOnDraw = new LinkedList<Runnable>();
        this.mRunOnDrawEnd = new LinkedList<Runnable>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runOnDraw(Runnable runnable) {
        Queue<Runnable> queue = this.mRunOnDraw;
        synchronized (queue) {
            this.mRunOnDraw.add(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runOnDrawEnd(Runnable runnable) {
        Queue<Runnable> queue = this.mRunOnDrawEnd;
        synchronized (queue) {
            this.mRunOnDrawEnd.add(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAll(Queue<Runnable> queue) {
        Queue<Runnable> queue2 = queue;
        synchronized (queue2) {
            while (!queue.isEmpty()) {
                queue.poll().run();
            }
        }
    }

    public void addFilterToDestroy(final GLRenderer renderer) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                FastImageProcessingPipeline.this.filtersToDestroy.add(renderer);
            }
        });
    }

    public synchronized void addRootRenderer(GLRenderer rootRenderer) {
        this.rootRenderers.add(rootRenderer);
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    private synchronized boolean isRendering() {
        return this.rendering;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDrawFrame(GL10 unused) {
        this.runAll(this.mRunOnDraw);
        if (this.isRendering()) {
            for (int i = 0; i < this.rootRenderers.size(); ++i) {
                GLRenderer gLRenderer;
                FastImageProcessingPipeline object = this;
                synchronized (object) {
                    gLRenderer = this.rootRenderers.get(i);
                }
                gLRenderer.onDrawFrame();
            }
        }
        List<GLRenderer> list = this.filtersToDestroy;
        synchronized (list) {
            for (GLRenderer gLRenderer : this.filtersToDestroy) {
                gLRenderer.destroy();
            }
            this.filtersToDestroy.clear();
        }
        this.runAll(this.mRunOnDrawEnd);
    }

    public void onSurfaceChanged(GL10 unused, int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void onSurfaceCreated(GL10 unused, EGLConfig config) {
    }

    public synchronized void pauseRendering() {
        this.rendering = false;
    }

    public synchronized void removeRootRenderer(GLRenderer rootRenderer) {
        this.rootRenderers.remove(rootRenderer);
    }

    public synchronized void startRendering() {
        if (this.rootRenderers.size() != 0) {
            this.rendering = true;
        }
    }

    public void destroy() {
        this.runOnDrawEnd(new Runnable(){

            @Override
            public void run() {
                for (GLRenderer gLRenderer : FastImageProcessingPipeline.this.rootRenderers) {
                    gLRenderer.destroy();
                }
                FastImageProcessingPipeline.this.rootRenderers.clear();
                for (GLRenderer gLRenderer : FastImageProcessingPipeline.this.filtersToDestroy) {
                    gLRenderer.destroy();
                }
                FastImageProcessingPipeline.this.filtersToDestroy.clear();
            }
        });
    }

    public void destroyIndeed() {
        for (GLRenderer gLRenderer : this.rootRenderers) {
            gLRenderer.destroy();
        }
        this.rootRenderers.clear();
        for (GLRenderer gLRenderer : this.filtersToDestroy) {
            gLRenderer.destroy();
        }
        this.filtersToDestroy.clear();
    }
}

