/*
 * Decompiled with CFR 0.152.
 */
package com.mm.mmutil.task;

import android.text.TextUtils;
import com.mm.mdlog.MDLog;
import com.mm.mmutil.app.AppContext;
import com.mm.mmutil.task.MomoThreadPoolExecutor;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class ThreadUtils {
    private static String TAG = "ThreadUtils";
    private static MomoThreadPoolExecutorInfo innerExecutorInfo = null;
    private static MomoThreadPoolExecutorInfo localExecutorInfo = null;
    private static MomoThreadPoolExecutorInfo rightNowExecutorInfo = null;
    private static MomoThreadPoolExecutorInfo messageExecutorInfo = null;
    private static MomoThreadPoolExecutorInfo statisticsExecutorInfo = null;
    private static final int INNER_THREAD_SIZE = 2;
    private static final int RIGHT_NOW_THREAD_SIZE = 10;
    private static final int RIGHT_NOW_LOCAL_THREAD_SIZE = 3;
    private static final int MESSAGE_THREAD_SIZE = 1;
    private static final int STATISTICS_THREAD_SIZE = 2;
    public static final int TYPE_INNER = 1;
    public static final int TYPE_RIGHT_NOW = 2;
    public static final int TYPE_RIGHT_NOW_LOCAL = 3;
    public static final int TYPE_MESSAGE = 4;
    public static final int TYPE_STATISTICS = 5;
    private static final TimeUnit DEFAULT_UNIT = TimeUnit.SECONDS;
    private static final long DEFAULT_KEEP_ALIVE_TIME = 60L;

    private static synchronized MomoThreadPoolExecutorInfo _getExecutorInfo(int type) {
        switch (type) {
            case 1: {
                if (null == innerExecutorInfo) {
                    innerExecutorInfo = new MomoThreadPoolExecutorInfo(type, 2, 2, 60L, DEFAULT_UNIT);
                }
                return innerExecutorInfo;
            }
            case 2: {
                if (null == rightNowExecutorInfo) {
                    rightNowExecutorInfo = TextUtils.equals((CharSequence)AppContext.getPackageName(), (CharSequence)AppContext.getCurrentProcessName()) ? new MomoThreadPoolExecutorInfo(type, 10, 10, 120L, DEFAULT_UNIT) : new MomoThreadPoolExecutorInfo(type, 5, 5, 60L, DEFAULT_UNIT);
                }
                return rightNowExecutorInfo;
            }
            case 3: {
                if (null == localExecutorInfo) {
                    localExecutorInfo = new MomoThreadPoolExecutorInfo(type, 3, 3, 60L, DEFAULT_UNIT);
                }
                return localExecutorInfo;
            }
            case 4: {
                if (null == messageExecutorInfo) {
                    messageExecutorInfo = new MomoThreadPoolExecutorInfo(type, 1, 1, 60L, DEFAULT_UNIT);
                }
                return messageExecutorInfo;
            }
            case 5: {
                if (null == statisticsExecutorInfo) {
                    statisticsExecutorInfo = new MomoThreadPoolExecutorInfo(type, 2, 2, 60L, DEFAULT_UNIT);
                }
                return statisticsExecutorInfo;
            }
        }
        throw new IllegalArgumentException("type=" + type + " not recognized");
    }

    static ScheduledThreadPoolExecutor _getExecutor(int type) {
        return ThreadUtils._getExecutorInfo(type).get();
    }

    private static Runnable withDebug(final Runnable command) {
        return AppContext.DEBUGGABLE ? new Runnable(){

            @Override
            public void run() {
                Thread thread = Thread.currentThread();
                String currentProcessName = AppContext.getCurrentProcessName();
                String threadName = thread.getName();
                long id = thread.getId();
                String runnableName = command.getClass().getName();
                MDLog.d((String)TAG, (String)"--> Thread start: [%s][%s][%s][%s]", (Object[])new Object[]{threadName, id, currentProcessName, runnableName});
                command.run();
                MDLog.d((String)TAG, (String)"--> Thread end: [%s][%s][%s][%s]", (Object[])new Object[]{threadName, id, currentProcessName, runnableName});
            }
        } : command;
    }

    private static <V> Callable<V> withDebug(final Callable<V> callable) {
        return AppContext.DEBUGGABLE ? new Callable<V>(){

            @Override
            public V call() throws Exception {
                Thread thread = Thread.currentThread();
                String currentProcessName = AppContext.getCurrentProcessName();
                String threadName = thread.getName();
                long id = thread.getId();
                String runnableName = callable.getClass().getName();
                MDLog.d((String)TAG, (String)"--> Thread start: [%s][%s][%s][%s]", (Object[])new Object[]{threadName, id, currentProcessName, runnableName});
                Object result = callable.call();
                MDLog.d((String)TAG, (String)"--> Thread end: [%s][%s][%s][%s]", (Object[])new Object[]{threadName, id, currentProcessName, runnableName});
                return result;
            }
        } : callable;
    }

    public static void execute(int type, Runnable command) {
        ThreadUtils.schedule(type, command, 0L, TimeUnit.NANOSECONDS);
    }

    public static ScheduledFuture<?> schedule(int type, Runnable command, long delay, TimeUnit unit) {
        if (command == null) {
            throw new IllegalArgumentException("command is null");
        }
        return ThreadUtils._getExecutor(type).schedule(ThreadUtils.withDebug(command), delay, unit);
    }

    public static <V> ScheduledFuture<V> schedule(int type, Callable<V> callable, long delay, TimeUnit unit) {
        if (callable == null) {
            throw new IllegalArgumentException("callable is null");
        }
        return ThreadUtils._getExecutor(type).schedule(ThreadUtils.withDebug(callable), delay, unit);
    }

    public static ScheduledFuture<?> scheduleAtFixedRate(int type, Runnable command, long initialDelay, long period, TimeUnit unit) {
        if (command == null) {
            throw new IllegalArgumentException("command is null");
        }
        return ThreadUtils._getExecutor(type).scheduleAtFixedRate(ThreadUtils.withDebug(command), initialDelay, period, unit);
    }

    public static ScheduledFuture<?> scheduleWithFixedDelay(int type, Runnable command, long initialDelay, long delay, TimeUnit unit) {
        if (command == null) {
            throw new IllegalArgumentException("command is null");
        }
        return ThreadUtils._getExecutor(type).scheduleWithFixedDelay(ThreadUtils.withDebug(command), initialDelay, delay, unit);
    }

    static void shutDown(int type) {
        ThreadUtils._getExecutorInfo(type).shutDown();
    }

    static synchronized void shutDownAll() {
        if (innerExecutorInfo != null) {
            innerExecutorInfo.shutDown();
        }
        if (localExecutorInfo != null) {
            localExecutorInfo.shutDown();
        }
        if (rightNowExecutorInfo != null) {
            rightNowExecutorInfo.shutDown();
        }
        if (messageExecutorInfo != null) {
            messageExecutorInfo.shutDown();
        }
        if (statisticsExecutorInfo != null) {
            statisticsExecutorInfo.shutDown();
        }
    }

    private static final class RejectedHandler
    implements RejectedExecutionHandler {
        private RejectedHandler() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            MDLog.e((String)TAG, (String)"Task %s rejected from %s", (Object[])new Object[]{r, executor});
        }
    }

    private static final class MMThread
    extends Thread {
        MMThread(Runnable target, String name) {
            super(target, name);
        }
    }

    private static final class MomoThreadFactory
    implements ThreadFactory {
        private final AtomicInteger mCount = new AtomicInteger(1);
        private final int type;

        MomoThreadFactory(int type) {
            this.type = type;
        }

        @Override
        public Thread newThread(Runnable r) {
            String threadName = "MMT" + this.type + " #" + this.mCount.getAndIncrement();
            if (AppContext.DEBUGGABLE) {
                MDLog.d((String)TAG, (String)"MomoThreadFactory -> newThread : %s", (Object[])new Object[]{threadName});
            }
            MMThread thread = new MMThread(r, threadName);
            if (this.type == 2 || this.type == 3) {
                thread.setPriority(10);
            } else {
                thread.setPriority(1);
            }
            return thread;
        }
    }

    private static final class MomoThreadPoolExecutorInfo {
        private MomoThreadPoolExecutor executor = null;
        private final int type;
        private final int corePoolSize;
        private final int maximumPoolSize;
        private final long keepAliveTime;
        private final TimeUnit unit;

        MomoThreadPoolExecutorInfo(int type, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit) {
            this.type = type;
            this.corePoolSize = corePoolSize;
            this.maximumPoolSize = maximumPoolSize;
            this.keepAliveTime = keepAliveTime;
            this.unit = unit;
        }

        synchronized MomoThreadPoolExecutor get() {
            if (null == this.executor) {
                this.executor = new MomoThreadPoolExecutor("MME" + this.type, this.corePoolSize, this.maximumPoolSize, this.keepAliveTime, this.unit, new LinkedBlockingQueue<Runnable>(), new MomoThreadFactory(this.type), new RejectedHandler());
                this.executor.allowCoreThreadTimeOut(true);
            }
            return this.executor;
        }

        synchronized void shutDown() {
            if (this.executor != null) {
                try {
                    this.executor.shutdownNow();
                }
                catch (Exception exception) {
                }
                finally {
                    this.executor = null;
                }
            }
        }
    }
}

