/*
 * Decompiled with CFR 0.152.
 */
package com.mm.mmutil.task;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.mm.mmutil.app.AppContext;
import com.mm.mmutil.log.Log4Android;
import com.mm.mmutil.task.ICommonTaskErrorProcessor;
import com.mm.mmutil.task.IInterruptable;
import com.mm.mmutil.task.ThreadUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class MomoTaskExecutor {
    @Deprecated
    public static final int EXECUTOR_TYPE_USER = 2;
    @Deprecated
    public static final int EXECUTOR_TYPE_INNER = 1;
    @Deprecated
    public static final int EXECUTOR_TYPE_LOCAL = 3;
    @Deprecated
    public static final int EXECUTOR_TYPE_MESSAGE = 4;
    private static final Map<Object, List<Task>> runningTasks = new ConcurrentHashMap<Object, List<Task>>();
    private static ICommonTaskErrorProcessor taskErrorProcessor;

    public static void setCommonTaskErrorProcessor(ICommonTaskErrorProcessor taskErrorProcessor) {
        MomoTaskExecutor.taskErrorProcessor = taskErrorProcessor;
    }

    public static void executeUserTask(Object tag, Task task) {
        MomoTaskExecutor.executeTask(2, tag, task);
    }

    public static void executeInnerTask(Object tag, Task task) {
        MomoTaskExecutor.executeTask(1, tag, task);
    }

    public static void executeLocalTask(Object tag, Task task) {
        MomoTaskExecutor.executeTask(3, tag, task);
    }

    public static void executeMessageTask(Object tag, Task task) {
        MomoTaskExecutor.executeTask(4, tag, task);
    }

    public static void executeTask(int type, Object tag, Task task) {
        if (tag == null) {
            throw new IllegalArgumentException("tag is null");
        }
        if (task == null) {
            throw new IllegalArgumentException("task is null");
        }
        task.onPreTask();
        task.tag = tag;
        if (AppContext.DEBUGGABLE) {
            Log4Android.getInstance().i("task[" + task.getClass().getName() + "] / thread[" + Thread.currentThread().getName() + "] : execute");
        }
        ThreadUtils.execute(type, task);
        List<Task> tasks = runningTasks.get(tag);
        if (tasks == null) {
            tasks = new CopyOnWriteArrayList<Task>();
        }
        tasks.add(task);
        runningTasks.put(tag, tasks);
    }

    public static void cancleAllTasksByTag(Object tag) {
        if (tag == null) {
            throw new IllegalArgumentException("tag is null");
        }
        List<Task> tasks = runningTasks.get(tag);
        if (tasks != null) {
            for (Task runningTask : tasks) {
                runningTask.cancel(true);
            }
            tasks.clear();
        }
        runningTasks.remove(tag);
    }

    public static void cancelAllTasks() {
        Set<Object> keys = runningTasks.keySet();
        for (Object tag : keys) {
            MomoTaskExecutor.cancleAllTasksByTag(tag);
        }
    }

    public static void cancleSpecificTask(Object tag, Task task) {
        if (tag == null) {
            throw new IllegalArgumentException("tag is null");
        }
        if (task == null) {
            throw new IllegalArgumentException("task is null");
        }
        task.cancel(true);
        List<Task> tasks = runningTasks.get(tag);
        if (tasks != null) {
            try {
                tasks.remove(task);
            }
            catch (UnsupportedOperationException e) {
                Log4Android.getInstance().e(e);
            }
            if (tasks.isEmpty()) {
                runningTasks.remove(tag);
            }
        }
    }

    public static abstract class Task<Params, Progress, Result>
    implements Runnable,
    IInterruptable {
        private static TaskHandler handler;
        private Params[] mParams;
        private volatile boolean isInterrupted = false;
        private volatile boolean isCancelled = false;
        private volatile long threadId;
        private Object tag;

        public Task() {
        }

        public Task(Params ... params) {
            this();
            this.mParams = params;
        }

        public final void cancel(boolean interrupt) {
            if (this.isCancelled) {
                return;
            }
            this.isCancelled = true;
            if (interrupt && !this.isInterrupted) {
                this.interrupt();
                this.killRuningHttpConnection();
            }
        }

        protected void onCancelled() {
        }

        private void finish() {
            List tasks;
            if (this.tag == null) {
                return;
            }
            if (this.isCancelled()) {
                AsyncResult result = new AsyncResult();
                result.task = this;
                Message message = Message.obtain();
                message.what = 3;
                message.obj = result;
                Task.getHandler().sendMessage(message);
            }
            if ((tasks = (List)runningTasks.get(this.tag)) != null) {
                try {
                    tasks.remove(this);
                }
                catch (UnsupportedOperationException e) {
                    Log4Android.getInstance().e(e);
                }
                if (tasks.isEmpty()) {
                    runningTasks.remove(this.tag);
                }
            }
        }

        private void killRuningHttpConnection() {
        }

        @Override
        public void interrupt() {
            this.isInterrupted = true;
        }

        @Override
        public void run() {
            Log4Android.getInstance().i("task[" + this.getClass().getName() + "] / thread[" + Thread.currentThread().getName() + "] : run");
            if (this.isInterrupted) {
                this.finish();
                return;
            }
            long startTime = System.currentTimeMillis();
            AsyncResult<Result, Progress> result = this.doInBackground(this.mParams);
            if (AppContext.DEBUGGABLE) {
                Log4Android.getInstance().i("task[" + this.getClass().getName() + "] / thread[" + Thread.currentThread().getName() + "] : doInBackground costs " + (System.currentTimeMillis() - startTime));
            }
            if (this.isInterrupted) {
                if (AppContext.DEBUGGABLE) {
                    Log4Android.getInstance().i("task[" + this.getClass().getName() + "] / thread[" + Thread.currentThread().getName() + "] : isInterrupted, finish");
                }
                this.finish();
                return;
            }
            Message message = Message.obtain();
            message.what = 1;
            message.obj = result;
            Task.getHandler().sendMessage(message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected static Handler getHandler() {
            if (handler != null) return handler;
            Class<MomoTaskExecutor> clazz = MomoTaskExecutor.class;
            synchronized (MomoTaskExecutor.class) {
                if (handler != null) return handler;
                handler = new TaskHandler();
                // ** MonitorExit[var0] (shouldn't be in output)
                return handler;
            }
        }

        public final boolean isCancelled() {
            return this.isCancelled;
        }

        protected abstract Result executeTask(Params ... var1) throws Exception;

        private final AsyncResult<Result, Progress> doInBackground(Params ... params) {
            AsyncResult result = new AsyncResult();
            try {
                if (!this.isCancelled()) {
                    this.threadId = Thread.currentThread().getId();
                    result.result = this.executeTask(params);
                } else {
                    result.exception = new Exception("task already canceled");
                }
            }
            catch (Throwable e) {
                result.exception = e;
            }
            result.task = this;
            return result;
        }

        protected final void publishProgress(Progress ... progress) {
            if (!this.isCancelled()) {
                AsyncResult result = new AsyncResult();
                result.progress = progress;
                result.task = this;
                Message message = Message.obtain();
                message.what = 2;
                message.obj = result;
                Task.getHandler().sendMessage(message);
            }
        }

        private final void onPostExecute(AsyncResult<Result, Progress> result) {
            this.finish();
            this.onTaskFinish();
            if (result.exception == null) {
                this.onTaskSuccess(result.result);
            } else if (result.exception instanceof Exception) {
                this.onTaskError((Exception)result.exception);
            } else {
                this.onTaskError(new Exception(result.exception));
            }
        }

        protected void onProgressUpdate(Progress ... values) {
        }

        protected void onPreTask() {
        }

        protected void onTaskFinish() {
        }

        protected void onTaskSuccess(Result result) {
        }

        protected void onTaskError(Exception e) {
            if (taskErrorProcessor != null) {
                taskErrorProcessor.processTaskError(e);
            }
        }

        private static class TaskHandler
        extends Handler {
            public static final int MSG_TYPE_POST_EXECUTE = 1;
            public static final int MSG_TYPE_PROGRESS_UPDATE = 2;
            public static final int MSG_TYPE_CANCLE = 3;

            public TaskHandler() {
                super(Looper.getMainLooper());
            }

            public void handleMessage(Message msg) {
                AsyncResult result = (AsyncResult)msg.obj;
                if (result == null || result.task == null) {
                    Log4Android.getInstance().i("task[null] / thread[" + Thread.currentThread().getName() + "] : handleMessage return");
                    return;
                }
                Task task = result.task;
                if (msg.what == 1) {
                    if (result.task.isInterrupted) {
                        Log4Android.getInstance().i("task[" + result.task.getClass().getName() + "] / thread[" + Thread.currentThread().getName() + "] : handleMessage isInterrupted, finish");
                        result.task.finish();
                    } else {
                        Log4Android.getInstance().i("task[" + result.task.getClass().getName() + "] / thread[" + Thread.currentThread().getName() + "] : handleMessage onPostExecute");
                        task.onPostExecute(result);
                    }
                } else if (msg.what == 2) {
                    if (!result.task.isInterrupted) {
                        task.onProgressUpdate(result.progress);
                    }
                } else if (msg.what == 3) {
                    task.onCancelled();
                }
            }
        }

        private static class AsyncResult<Params, Progress> {
            Task task;
            Params result;
            Progress[] progress;
            Throwable exception;

            private AsyncResult() {
            }
        }
    }
}

