/*
 * Decompiled with CFR 0.152.
 */
package com.mm.mmutil.task;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;

public class MomoMainThreadExecutor {
    private static Handler handler;

    public static void post(Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("runnable is null");
        }
        MomoMainThreadExecutor.getHandler().post(runnable);
    }

    public static void post(Object tag, Runnable runnable) {
        if (tag instanceof Number || tag instanceof CharSequence) {
            tag = tag.toString().intern();
        }
        Message message = Message.obtain((Handler)MomoMainThreadExecutor.getHandler(), (Runnable)runnable);
        message.obj = tag;
        MomoMainThreadExecutor.getHandler().sendMessage(message);
    }

    public static void postAtFrontOfQueue(Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("runnable is null");
        }
        MomoMainThreadExecutor.getHandler().postAtFrontOfQueue(runnable);
    }

    public static void postDelayed(Object tag, Runnable runnable, long delayMill) {
        if (tag == null) {
            throw new IllegalArgumentException("tag is null");
        }
        if (runnable == null) {
            throw new IllegalArgumentException("runnable is null");
        }
        if (delayMill <= 0L) {
            throw new IllegalArgumentException("delayMill <= 0");
        }
        if (tag instanceof Number || tag instanceof CharSequence) {
            tag = tag.toString().intern();
        }
        Message message = Message.obtain((Handler)MomoMainThreadExecutor.getHandler(), (Runnable)runnable);
        message.obj = tag;
        MomoMainThreadExecutor.getHandler().sendMessageDelayed(message, delayMill);
    }

    public static void cancelSpecificRunnable(Object tag, Runnable runnable) {
        if (tag == null) {
            throw new IllegalArgumentException("tag is null");
        }
        if (runnable == null) {
            throw new IllegalArgumentException("runnable is null");
        }
        if (tag instanceof Number || tag instanceof CharSequence) {
            tag = tag.toString().intern();
        }
        MomoMainThreadExecutor.getHandler().removeCallbacks(runnable, tag);
    }

    public static void cancelAllRunnables(Object tag) {
        if (tag == null) {
            throw new IllegalArgumentException("tag is null");
        }
        if (tag instanceof Number || tag instanceof CharSequence) {
            tag = tag.toString().intern();
        }
        MomoMainThreadExecutor.getHandler().removeCallbacksAndMessages(tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Handler getHandler() {
        if (handler != null) return handler;
        Class<MomoMainThreadExecutor> clazz = MomoMainThreadExecutor.class;
        synchronized (MomoMainThreadExecutor.class) {
            if (handler != null) return handler;
            handler = new Handler(Looper.getMainLooper());
            // ** MonitorExit[var0] (shouldn't be in output)
            return handler;
        }
    }
}

