/*
 * Decompiled with CFR 0.152.
 */
package com.mm.mmutil.log;

import android.text.TextUtils;
import com.mm.mdlog.MDLog;
import com.mm.mmutil.app.AppContext;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;

@Deprecated
public class Log4Android {
    private static final String TAG = "momo";
    public static boolean enableSaveLog = false;
    private static Log4Android instance = null;
    private String tag = "momo";
    private String msgPrefix = "";
    private String msgPostfix = "";
    private File saveFile = null;
    private BufferedWriter writer = null;
    private boolean isDebug = AppContext.DEBUGGABLE;
    private String processName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Log4Android getInstance() {
        if (instance != null) return instance;
        Class<Log4Android> clazz = Log4Android.class;
        synchronized (Log4Android.class) {
            if (instance != null) return instance;
            instance = new Log4Android();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Deprecated
    public Log4Android() {
    }

    @Deprecated
    public Log4Android(String tag) {
        this.setTag(tag);
    }

    @Deprecated
    public Log4Android(Object clazz) {
        this(clazz.getClass().getSimpleName());
    }

    public Log4Android(String tag, File saveFile) {
        this(saveFile);
        this.setTag(tag);
    }

    private Log4Android(File saveFile) {
        if (saveFile == null) {
            return;
        }
        if (!saveFile.exists()) {
            saveFile.mkdirs();
        }
        if (saveFile.isDirectory()) {
            String newFilePath = "auto_create_" + System.currentTimeMillis() + ".log";
            Log4Android.printLog("Warning: saveFile is a directory, path = \u2018" + saveFile.getAbsolutePath() + "\u2019. create a " + "new file \u2018" + newFilePath + "\u2019");
            saveFile = new File(saveFile, newFilePath);
            try {
                saveFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.saveFile = saveFile;
    }

    public static void saveLog(String log, String tag, LOG_LEVEL level, File saveFile) {
        Log4Android.writeToFile(saveFile, log);
    }

    public static void saveLog(Throwable tr, String tag, File saveFile) {
        StringBuilder stringBuilder = new StringBuilder();
        if (tr != null) {
            Log4Android.formatErrorStack(stringBuilder, tr);
        }
        Log4Android.saveLog(stringBuilder.toString(), tag, LOG_LEVEL.LOG_ERROR, saveFile);
    }

    public static void saveLog(StringBuilder sb, Throwable tr, String tag, File saveFile) {
        if (tr != null) {
            Log4Android.formatErrorStack(sb, tr);
        }
        Log4Android.saveLog(sb.toString(), tag, LOG_LEVEL.LOG_ERROR, saveFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(File saveFile, CharSequence log) {
        FileWriter writer = null;
        try {
            writer = new FileWriter(saveFile, true);
            ((Writer)writer).append(log);
            ((Writer)writer).flush();
        }
        catch (Exception exception) {
        }
        finally {
            if (writer != null) {
                try {
                    ((Writer)writer).close();
                }
                catch (IOException iOException) {}
                writer = null;
            }
        }
    }

    public static void formatErrorStack(Appendable err, Throwable tr) {
        Log4Android.formatErrorStack(err, "", tr);
    }

    public static void formatErrorStack(Appendable err, String indent, Throwable tr) {
        try {
            StringWriter result = new StringWriter(512);
            PrintWriter printWriter = new PrintWriter(result);
            for (Throwable cause = tr; cause != null; cause = cause.getCause()) {
                cause.printStackTrace(printWriter);
            }
            String stacktraceAsString = ((Object)result).toString();
            printWriter.close();
            err.append(stacktraceAsString);
        }
        catch (Exception e) {
            throw new AssertionError();
        }
    }

    public static void printLog(String log) {
        if (AppContext.DEBUGGABLE) {
            MDLog.i((String)TAG, (String)("MOMO==** " + log));
        }
    }

    public static void printLog(String tag, String log) {
        if (AppContext.DEBUGGABLE) {
            MDLog.i((String)tag, (String)log);
        }
    }

    public Log4Android closeDebug() {
        this.isDebug = false;
        return this;
    }

    public Log4Android openDebug() {
        this.isDebug = true;
        return this;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public String getMsgPrefix() {
        return this.msgPrefix;
    }

    public void setMsgPrefix(String msgPrefix) {
        this.msgPrefix = msgPrefix;
    }

    public String getMsgPostfix() {
        return this.msgPostfix;
    }

    public void setMsgPostfix(String msgPostfix) {
        this.msgPostfix = msgPostfix;
    }

    public void saveLog(File saveFile) {
        this.saveFile = saveFile;
    }

    public File getSaveFile() {
        return this.saveFile;
    }

    public void d(Object debug) {
        this.d(this.tag, debug);
    }

    public void d(String tag, Object debug) {
        MDLog.d((String)tag, (String)(this.msgPrefix + (debug != null ? debug.toString() : "null") + this.msgPostfix));
    }

    public void i(Object log) {
        this.i(this.tag, log);
    }

    public void i(String tag, Object log) {
        MDLog.i((String)tag, (String)(this.msgPrefix + (log != null ? log.toString() : "null") + this.msgPostfix));
    }

    public void w(Object warn) {
        this.w(this.tag, warn);
    }

    public void w(String tag, Object warn) {
        MDLog.w((String)tag, (String)(this.msgPrefix + (warn != null ? warn.toString() : "null") + this.msgPostfix));
    }

    public void e(Throwable tr) {
        this.e(this.tag, tr);
    }

    public void e(String msg, Throwable tr) {
        this.e(this.tag, msg, tr);
    }

    public void e(String tag, String msg, Throwable tr) {
        MDLog.printErrStackTrace((String)tag, (Throwable)tr, (String)"%s", (Object[])new Object[]{this.msgPrefix + (msg != null ? msg.toString() : "null") + this.msgPostfix});
    }

    public void printLog(String log, Throwable tr, LOG_LEVEL level) {
        this.printLog(null, log, tr, level);
    }

    public void printLog(String newTag, String log, Throwable tr, LOG_LEVEL level) {
        String tag = TextUtils.isEmpty((CharSequence)newTag) ? this.tag : newTag;
        boolean saveLog = this.saveFile != null && enableSaveLog;
        StringBuilder stringBuilder = null;
        if (saveLog) {
            if (this.processName == null) {
                this.processName = AppContext.getCurrentProcessName();
            }
            if (TextUtils.isEmpty((CharSequence)this.processName)) {
                this.processName = "unknown";
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("MM-dd HH:mm:ss.SSS");
            stringBuilder = new StringBuilder().append(dateFormat.format(new Date())).append(" ").append(this.processName).append(" ").append(level.name() + "/" + tag + " ");
        }
        switch (level) {
            case LOG_DEBUG: {
                if (this.isDebug) {
                    MDLog.d((String)tag, (String)log);
                }
                if (!saveLog) break;
                stringBuilder.append(log);
                break;
            }
            case LOG_ERROR: {
                if (saveLog) {
                    Log4Android.formatErrorStack(stringBuilder, tr);
                }
                if (!this.isDebug) break;
                if (tr == null) {
                    MDLog.e((String)tag, (String)log);
                    break;
                }
                MDLog.e((String)tag, (String)log, (Object[])new Object[]{tr});
                break;
            }
            case LOG_INFO: {
                if (this.isDebug) {
                    MDLog.i((String)tag, (String)log);
                }
                if (!saveLog) break;
                stringBuilder.append(log);
                break;
            }
            case LOG_VERBOSE: {
                if (!this.isDebug) break;
                MDLog.v((String)tag, (String)log);
                break;
            }
            case LOG_WARNING: {
                if (this.isDebug) {
                    MDLog.w((String)tag, (String)log);
                }
                if (!saveLog) break;
                stringBuilder.append(log);
                break;
            }
        }
        if (saveLog) {
            stringBuilder.append("\n");
            if (saveLog) {
                this.saveLog(stringBuilder);
            }
        }
    }

    public void close() {
        try {
            this.saveFile = null;
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    private void saveLog(CharSequence log) {
        if (this.saveFile == null || !this.saveFile.exists()) {
            return;
        }
        try {
            if (this.writer == null) {
                this.writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.saveFile)));
            }
            this.writer.append(log);
            this.writer.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void longInfo(String str) {
        if (str.length() > 4000) {
            this.i(str.substring(0, 4000));
            this.longInfo(str.substring(4000));
        } else {
            this.i(str);
        }
    }

    public long log4Cast(String pre, long start) {
        long end = System.currentTimeMillis();
        if (!this.isDebug) {
            return end;
        }
        this.d(pre + " " + (end - start));
        return end;
    }

    public static enum LOG_LEVEL {
        LOG_INFO,
        LOG_DEBUG,
        LOG_ERROR,
        LOG_WARNING,
        LOG_VERBOSE;

    }
}

