/*
 * Decompiled with CFR 0.152.
 */
package com.mm.mmutil.app;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Looper;
import android.os.Process;
import android.text.TextUtils;
import com.mm.mdlog.MDLog;
import com.mm.mmutil.IOUtils;
import com.mm.mmutil.log.Log4Android;
import java.io.FileInputStream;
import java.util.List;
import java.util.Locale;

public class AppContext {
    public static Context sContext;
    public static boolean DEBUGGABLE;
    private static String sPackageName;
    private static ContentResolver sContentResolver;
    private static String currentProcessName;

    public static void init(Context context) {
        sContext = context;
    }

    public static Context getContext() {
        return sContext;
    }

    public static void openDebug() {
        DEBUGGABLE = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCurrentProcessName() {
        if (sContext == null) {
            return null;
        }
        if (!TextUtils.isEmpty((CharSequence)currentProcessName)) {
            return currentProcessName;
        }
        int myPid = Process.myPid();
        if (myPid <= 0) {
            return "";
        }
        ActivityManager.RunningAppProcessInfo myProcess = null;
        ActivityManager activityManager = (ActivityManager)AppContext.getContext().getSystemService("activity");
        try {
            for (ActivityManager.RunningAppProcessInfo process : activityManager.getRunningAppProcesses()) {
                if (process.pid != myPid) continue;
                myProcess = process;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (myProcess != null) {
            return myProcess.processName;
        }
        byte[] b = new byte[128];
        FileInputStream in = null;
        try {
            in = new FileInputStream("/proc/" + myPid + "/cmdline");
            int len = in.read(b);
            if (len > 0) {
                for (int i = 0; i < len; ++i) {
                    if (b[i] <= 128 && b[i] > 0) continue;
                    len = i;
                    break;
                }
                String string = new String(b, 0, len);
                IOUtils.closeQuietly(in);
                return string;
            }
            IOUtils.closeQuietly(in);
        }
        catch (Exception e) {
            MDLog.printErrStackTrace((String)AppContext.class.getName(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(in);
        }
        return "";
    }

    public static boolean isAppOnForeground() {
        if (null == sContext) {
            return false;
        }
        try {
            ActivityManager activityManager = (ActivityManager)sContext.getSystemService("activity");
            List appProcesses = activityManager.getRunningAppProcesses();
            if (appProcesses == null) {
                return false;
            }
            int myPid = Process.myPid();
            for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
                if (appProcess.importance != 100 || appProcess.pid != myPid) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isRunningInMainProcess() {
        String processName = AppContext.getCurrentProcessName();
        return !TextUtils.isEmpty((CharSequence)processName) && processName.equals(sContext.getPackageName());
    }

    public static boolean isRunningInMainThread() {
        Looper myLooper = Looper.myLooper();
        Looper mainLooper = Looper.getMainLooper();
        Log4Android.getInstance().i("isRunningInMainThread myLooper=" + myLooper + ", mainLooper=" + mainLooper);
        return myLooper == mainLooper;
    }

    public static String getPackageName() {
        if (sContext == null) {
            return null;
        }
        if (sPackageName == null && (sPackageName = sContext.getPackageName()).indexOf(":") >= 0) {
            sPackageName = sPackageName.substring(0, sPackageName.lastIndexOf(":"));
        }
        return sPackageName;
    }

    public static ContentResolver getContentResolver() {
        if (sContentResolver == null) {
            sContentResolver = AppContext.getContext().getContentResolver();
        }
        return sContentResolver;
    }

    public static String getSystemCountry() {
        return Locale.getDefault().getCountry();
    }

    public static String getSystemLanguage() {
        return Locale.getDefault().getLanguage();
    }

    static {
        sPackageName = null;
        sContentResolver = null;
    }
}

