/*
 * Decompiled with CFR 0.152.
 */
package com.mm.mmutil;

import android.content.Context;
import android.content.res.AssetManager;
import android.text.TextUtils;
import com.mm.mdlog.MDLog;
import com.mm.mmutil.IOUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FileUtil {
    private static final String Tag = "momo FileUtil";
    private static final char EXTENSION_SEPARATOR = '.';
    private static final char DIRECTORY_SEPARATOR = '/';
    public static String KEY_UNIQUE_ID = "";
    private static final String[] INVALID_ZIP_ENTRY_NAME = new String[]{"../", "~/"};

    public static void setUniqueIDKey(String key_unique_id) {
        KEY_UNIQUE_ID = key_unique_id;
    }

    public static void resetCurrentUser() {
        KEY_UNIQUE_ID = "";
    }

    public static boolean isUserFileValid() {
        return !TextUtils.isEmpty((CharSequence)KEY_UNIQUE_ID);
    }

    public static File newFile(String path) {
        File retFile = new File(path);
        try {
            if (!retFile.exists()) {
                retFile.createNewFile();
            }
        }
        catch (Throwable e) {
            MDLog.printErrStackTrace((String)Tag, (Throwable)e);
        }
        return retFile;
    }

    public static File newFile(File dirFile, String fileName) {
        File targetFile = new File(dirFile, fileName);
        try {
            if (!targetFile.exists()) {
                targetFile.createNewFile();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return targetFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean writeStream(InputStream stream, File destFile) throws IOException {
        if (stream == null || destFile == null) {
            return false;
        }
        FileOutputStream fos = null;
        boolean result = false;
        try {
            if (!destFile.exists()) {
                destFile.createNewFile();
            }
            byte[] buffer = new byte[2048];
            fos = new FileOutputStream(destFile);
            int len = 0;
            while ((len = stream.read(buffer)) != -1) {
                fos.write(buffer, 0, len);
            }
            result = true;
        }
        catch (IOException iOException) {
            IOUtils.closeAllQuietly(stream, fos);
            catch (Throwable throwable) {
                IOUtils.closeAllQuietly(stream, fos);
                throw throwable;
            }
        }
        IOUtils.closeAllQuietly(stream, fos);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean writeBytes(byte[] data, File destFile) {
        if (data == null || destFile == null || destFile.isDirectory()) {
            return false;
        }
        FileOutputStream fos = null;
        boolean success = false;
        try {
            if (!destFile.exists()) {
                destFile.createNewFile();
            }
            fos = new FileOutputStream(destFile);
            fos.write(data);
            success = true;
        }
        catch (IOException iOException) {
            IOUtils.closeQuietly(fos);
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(fos);
        return success;
    }

    public static void writeStr(File targetFile, String strToWrite) throws IOException {
        FileUtil.writeStr(targetFile, strToWrite, false);
    }

    private static void writeStr(File targetFile, String strToWrite, boolean append) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(targetFile, append);
            fileOutputStream.write(strToWrite.getBytes(Charset.forName("UTF-8")));
        }
        catch (IOException e) {
            try {
                MDLog.printErrStackTrace((String)Tag, (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileOutputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(fileOutputStream);
    }

    public static void writeStr(String targetFilePath, String strToWrite) throws IOException {
        FileUtil.writeStr(targetFilePath, strToWrite, false);
    }

    public static void writeStrAppend(String targetFilePath, String strToWrite) throws IOException {
        FileUtil.writeStr(targetFilePath, strToWrite, true);
    }

    private static void writeStr(String targetFilePath, String strToWrite, boolean append) throws IOException {
        File targetFile = FileUtil.newFile(targetFilePath);
        if (targetFile.exists()) {
            FileUtil.writeStr(targetFile, strToWrite, append);
        } else {
            MDLog.printErrStackTrace((String)Tag, (Throwable)new Exception("File doesn't exist!"));
        }
    }

    public static boolean isValidFile(File file) {
        return null != file && file.exists() && file.length() > 0L;
    }

    public static String readStr(File targetFile) throws IOException {
        String string;
        if (!targetFile.exists()) {
            return "";
        }
        BufferedInputStream inputStream = null;
        ByteArrayOutputStream bos = null;
        try {
            int len;
            inputStream = new BufferedInputStream(new FileInputStream(targetFile));
            bos = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((len = inputStream.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
            }
            string = new String(bos.toByteArray());
        }
        catch (IOException e) {
            try {
                MDLog.printErrStackTrace((String)Tag, (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.closeAllQuietly(inputStream, bos);
                throw throwable;
            }
        }
        IOUtils.closeAllQuietly(inputStream, bos);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        FileInputStream fis = null;
        byte[] data = null;
        try {
            fis = new FileInputStream(file);
            data = new byte[fis.available()];
            fis.read(data);
        }
        catch (IOException ex) {
            try {
                MDLog.printErrStackTrace((String)Tag, (Throwable)ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
            IOUtils.closeQuietly(fis);
        }
        IOUtils.closeQuietly(fis);
        return data;
    }

    public static String readStr(String target) throws IOException {
        File targetFile = FileUtil.newFile(target);
        return FileUtil.readStr(targetFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeObjectToFile(File targetFile, Serializable serializable) {
        if (!targetFile.exists()) {
            return;
        }
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(targetFile)));
            oos.writeObject(serializable);
            IOUtils.closeQuietly(oos);
        }
        catch (IOException e) {
            MDLog.printErrStackTrace((String)Tag, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(oos);
        }
    }

    public static Object readObjectFromFile(File targetFile) {
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(targetFile)));
            Object object = objectInputStream.readObject();
            IOUtils.closeQuietly(objectInputStream);
            return object;
        }
        catch (Exception e) {
            MDLog.printErrStackTrace((String)Tag, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(objectInputStream);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyAssets(Context context, String fileName, File destFile) {
        if (TextUtils.isEmpty((CharSequence)fileName) || destFile == null) {
            return false;
        }
        boolean isSuccess = false;
        AssetManager assetManager = context.getAssets();
        InputStream in = null;
        FileOutputStream out = null;
        try {
            in = assetManager.open(fileName);
            out = new FileOutputStream(destFile);
            FileUtil.copyFile(in, out);
            isSuccess = true;
        }
        catch (IOException e) {
            MDLog.printErrStackTrace((String)Tag, (Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException e) {
                MDLog.printErrStackTrace((String)Tag, (Throwable)e);
            }
        }
        return isSuccess;
    }

    private static void copyFile(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[1024];
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
    }

    public static void copyFile(File oldFile, File newFile) throws IOException {
        InputStream is = null;
        OutputStream os = null;
        try {
            is = new BufferedInputStream(new FileInputStream(oldFile), 4096);
            os = new BufferedOutputStream(new FileOutputStream(newFile), 4096);
            int len = -1;
            byte[] buffer = new byte[4096];
            while ((len = is.read(buffer)) != -1) {
                os.write(buffer, 0, len);
            }
            os.flush();
        }
        catch (IOException e) {
            if (newFile.exists()) {
                newFile.delete();
            }
            throw e;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renameTo(File oldFile, File newFile) throws IOException {
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            int len;
            is = new FileInputStream(oldFile);
            os = new FileOutputStream(newFile);
            byte[] buffer = new byte[2048];
            while ((len = ((InputStream)is).read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, len);
            }
            oldFile.delete();
        }
        catch (Throwable throwable) {
            IOUtils.closeAllQuietly(is, os);
            throw throwable;
        }
        IOUtils.closeAllQuietly(is, os);
    }

    public static boolean renameToSimple(File oldFile, File newFile) throws IOException {
        return null != oldFile && null != newFile && oldFile.renameTo(newFile);
    }

    public static boolean unzip(String zipFile, String targetDir) {
        return FileUtil.unzip(zipFile, targetDir, false);
    }

    public static boolean unzip(String zipFile, String targetDir, boolean nomedia) {
        boolean unzipSuccess;
        try {
            unzipSuccess = true;
            FileUtil.unzipWithExeption(zipFile, targetDir, nomedia);
        }
        catch (Exception e) {
            MDLog.printErrStackTrace((String)Tag, (Throwable)e);
            unzipSuccess = false;
        }
        return unzipSuccess;
    }

    public static void unzipWithExeption(String zipFile, String targetDir) throws Exception {
        FileUtil.unzipWithExeption(zipFile, targetDir, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzipWithExeption(String zipFile, String targetDir, boolean nomedia) throws Exception {
        int BUFFER = 4096;
        FilterOutputStream dest = null;
        FileInputStream fis = new FileInputStream(zipFile);
        try (ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                File nomeidiaFile;
                byte[] data = new byte[BUFFER];
                String strEntry = entry.getName();
                if (!FileUtil.validEntry(strEntry)) {
                    throw new IllegalArgumentException("unsecurity zipfile!");
                }
                File entryFile = new File(targetDir, strEntry);
                if (entry.isDirectory()) {
                    if (entryFile.exists()) continue;
                    entryFile.mkdirs();
                    continue;
                }
                File entryDir = new File(entryFile.getParent());
                if (!entryDir.exists()) {
                    entryDir.mkdirs();
                }
                if (nomedia && !(nomeidiaFile = new File(entryDir, ".nomedia")).exists()) {
                    nomeidiaFile.createNewFile();
                }
                try {
                    int count;
                    dest = new BufferedOutputStream(new FileOutputStream(entryFile), BUFFER);
                    while ((count = zis.read(data, 0, BUFFER)) != -1) {
                        ((BufferedOutputStream)dest).write(data, 0, count);
                    }
                    ((BufferedOutputStream)dest).flush();
                }
                finally {
                    dest.close();
                }
            }
        }
    }

    public static boolean validEntry(String name) {
        int l = INVALID_ZIP_ENTRY_NAME.length;
        for (int i = 0; i < l; ++i) {
            if (!name.contains(INVALID_ZIP_ENTRY_NAME[i])) continue;
            return false;
        }
        return true;
    }

    public static String formartFileSize(long filesize_byte) {
        long filesize_kb = filesize_byte / 1024L;
        double filesize_mb = (float)filesize_kb / 1024.0f;
        if (filesize_mb > 1.0) {
            NumberFormat formator = NumberFormat.getNumberInstance();
            formator.setMaximumFractionDigits(2);
            return formator.format(filesize_mb) + "M";
        }
        return filesize_kb + "K";
    }

    public static String removeExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int index = FileUtil.indexOfExtension(filename);
        if (index == -1) {
            return filename;
        }
        return filename.substring(0, index);
    }

    public static int indexOfExtension(String filename) {
        if (filename == null) {
            return -1;
        }
        int extensionPos = filename.lastIndexOf(46);
        int lastDirSeparator = filename.lastIndexOf(47);
        if (lastDirSeparator > extensionPos) {
            MDLog.w((String)Tag, (String)"A directory separator appears after the file extension, assuming there is no file extension");
            return -1;
        }
        return extensionPos;
    }

    public static void writeStrAppend(File file, String data) throws IOException {
        FileUtil.writeStr(file, data, true);
    }

    public static void deleteDir(File dir) {
        if (dir == null) {
            return;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    FileUtil.deleteDir(f);
                    continue;
                }
                f.delete();
            }
        }
        dir.delete();
    }
}

