/*
 * Decompiled with CFR 0.152.
 */
package com.mm.mmutil;

import android.content.ContentResolver;
import android.hardware.Camera;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.telephony.cdma.CdmaCellLocation;
import android.telephony.gsm.GsmCellLocation;
import android.text.TextUtils;
import com.mm.mmutil.IOUtils;
import com.mm.mmutil.app.AppContext;
import com.mm.mmutil.log.Log4Android;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Properties;

public class BaseDeviceUtils {
    private static int isFlyme = -1;

    public static boolean isJBVsersion() {
        return Build.VERSION.SDK_INT >= 16;
    }

    public static String getOSVersion() {
        return Build.VERSION.RELEASE;
    }

    public static int getSDKVersion() {
        return Build.VERSION.SDK_INT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFlyme() {
        FileInputStream fis;
        block6: {
            if (isFlyme != -1) {
                return isFlyme == 1;
            }
            isFlyme = 0;
            fis = null;
            try {
                fis = new FileInputStream(new File(Environment.getRootDirectory(), "build.prop"));
                Properties prop = new Properties();
                prop.load(fis);
                String facturer = prop.getProperty("ro.product.manufacturer", null);
                String brand = prop.getProperty("ro.product.brand", null);
                if (!TextUtils.equals((CharSequence)facturer, (CharSequence)"Meizu") && !TextUtils.equals((CharSequence)brand, (CharSequence)"Meizu")) break block6;
                isFlyme = 1;
            }
            catch (Throwable ex) {
                try {
                    ex.printStackTrace();
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    IOUtils.closeQuietly(fis);
                }
            }
        }
        IOUtils.closeQuietly(fis);
        return isFlyme == 1;
    }

    public static boolean isMockLocationSet() {
        if (Build.VERSION.SDK_INT >= 23) {
            return false;
        }
        return "1".equals(Settings.Secure.getString((ContentResolver)AppContext.getContentResolver(), (String)"mock_location"));
    }

    public static String getSimSubscriberId() {
        TelephonyManager tm = (TelephonyManager)AppContext.getContext().getSystemService("phone");
        if (tm != null) {
            return tm.getSubscriberId();
        }
        return "";
    }

    public static boolean isHasSimCard() {
        TelephonyManager tm = (TelephonyManager)AppContext.getContext().getSystemService("phone");
        if (tm != null) {
            return tm.getSimState() != 1;
        }
        return false;
    }

    public static String getRadioDetail() {
        TelephonyManager tm = (TelephonyManager)AppContext.getContext().getSystemService("phone");
        return tm.getNetworkType() + "";
    }

    public static String getPhoneNumber() {
        TelephonyManager tm = (TelephonyManager)AppContext.getContext().getSystemService("phone");
        if (tm != null) {
            return tm.getLine1Number();
        }
        return "";
    }

    public static String getSimOperatorNumber() {
        TelephonyManager tm = (TelephonyManager)AppContext.getContext().getSystemService("phone");
        if (tm != null) {
            return tm.getSimOperator();
        }
        return "";
    }

    public static boolean isHoneycomb() {
        return Build.VERSION.SDK_INT >= 11;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    public static String getCpuName() {
        String string;
        FileReader fr = null;
        try {
            fr = new FileReader("/proc/cpuinfo");
            BufferedReader br = new BufferedReader(fr);
            String text = br.readLine();
            String[] array = text.split(":\\s+", 2);
            for (int i = 0; i < array.length; ++i) {
            }
            string = array[1];
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            IOUtils.closeQuietly(fr);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fr);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(fr);
        }
        IOUtils.closeQuietly(fr);
        return string;
        return null;
    }

    public static int getCameraNumbers() {
        return Camera.getNumberOfCameras();
    }

    public static String getAndroidId() {
        String androidId = "";
        try {
            androidId = Settings.Secure.getString((ContentResolver)AppContext.getContext().getContentResolver(), (String)"android_id");
        }
        catch (Throwable ex) {
            Log4Android.getInstance().e(ex);
        }
        return androidId;
    }

    public static String getBrand() {
        if (TextUtils.isEmpty((CharSequence)Build.BRAND)) {
            return "unknown";
        }
        return Build.BRAND;
    }

    public static String getBaseband() {
        try {
            Class<?> cl = Class.forName("android.os.SystemProperties");
            Object invoker = cl.newInstance();
            Method m = cl.getMethod("get", String.class, String.class);
            Object result = m.invoke(invoker, "gsm.version.baseband", "no message");
            if (result != null) {
                return result.toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static String getIMSI() {
        TelephonyManager telephonyManager = (TelephonyManager)AppContext.getContext().getSystemService("phone");
        return telephonyManager.getSimSerialNumber();
    }

    public static int getCellid() {
        TelephonyManager tm = (TelephonyManager)AppContext.getContext().getSystemService("phone");
        int cellid = 0;
        try {
            CdmaCellLocation location;
            if (tm.getCellLocation() instanceof GsmCellLocation) {
                GsmCellLocation location2 = (GsmCellLocation)tm.getCellLocation();
                if (location2 != null) {
                    cellid = location2.getCid();
                }
            } else if (tm.getCellLocation() instanceof CdmaCellLocation && (location = (CdmaCellLocation)tm.getCellLocation()) != null) {
                cellid = location.getBaseStationId();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cellid;
    }

    public static String getBSSID() {
        WifiManager wm = (WifiManager)AppContext.getContext().getSystemService("wifi");
        WifiInfo info = wm.getConnectionInfo();
        return info.getBSSID();
    }

    public static String getMAC() {
        String mac = "";
        try {
            WifiManager wifi = (WifiManager)AppContext.getContext().getSystemService("wifi");
            WifiInfo info = wifi.getConnectionInfo();
            if (info != null && !TextUtils.isEmpty((CharSequence)info.getMacAddress())) {
                mac = info.getMacAddress();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mac;
    }

    public static String getSmsPayOperator() {
        String opName = BaseDeviceUtils.getSimOperatorNumber();
        if ("46001".equals(opName) || "46006".equals(opName)) {
            return "unicom";
        }
        if ("46000".equals(opName) || "46002".equals(opName) || "46007".equals(opName)) {
            return "mobile";
        }
        if ("46003".equals(opName) || "46005".equals(opName)) {
            return "telecom";
        }
        return "";
    }
}

