/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.baseutil.hw;

import java.nio.ByteBuffer;

public class NV21Convertor {
    ByteBuffer mCopy;
    private int mSliceHeight;
    private int mHeight;
    private int mStride;
    private int mWidth;
    private int mSize;
    private boolean mPlanar;
    private boolean mPanesReversed = false;
    private int mYPadding;
    private byte[] mBuffer;

    public void setSize(int n, int n2) {
        this.mHeight = n2;
        this.mWidth = n;
        this.mSliceHeight = n2;
        this.mStride = n;
        this.mSize = this.mWidth * this.mHeight;
    }

    public int getBufferSize() {
        return 3 * this.mSize / 2;
    }

    public void setEncoderColorFormat(int n) {
        switch (n) {
            case 21: 
            case 39: 
            case 2130706688: 
            case 2141391872: {
                this.setPlanar(false);
                break;
            }
            case 19: 
            case 20: {
                this.setPlanar(true);
                break;
            }
            default: {
                this.setPlanar(true);
            }
        }
    }

    public void setColorPanesReversed(boolean bl) {
        this.mPanesReversed = bl;
    }

    public int getStride() {
        return this.mStride;
    }

    public void setStride(int n) {
        this.mStride = n;
    }

    public int getSliceHeigth() {
        return this.mSliceHeight;
    }

    public void setSliceHeigth(int n) {
        this.mSliceHeight = n;
    }

    public int getYPadding() {
        return this.mYPadding;
    }

    public void setYPadding(int n) {
        this.mYPadding = n;
    }

    public boolean getPlanar() {
        return this.mPlanar;
    }

    public void setPlanar(boolean bl) {
        this.mPlanar = bl;
    }

    public boolean getUVPanesReversed() {
        return this.mPanesReversed;
    }

    public void convert(byte[] byArray, ByteBuffer byteBuffer) {
        byte[] byArray2 = this.convert(byArray);
        int n = byteBuffer.capacity() < byArray.length ? byteBuffer.capacity() : byArray.length;
        byteBuffer.put(byArray2, 0, n);
    }

    public byte[] convert(byte[] byArray) {
        if (this.mBuffer == null || this.mBuffer.length != 3 * this.mSliceHeight * this.mStride / 2 + this.mYPadding) {
            this.mBuffer = new byte[3 * this.mSliceHeight * this.mStride / 2 + this.mYPadding];
        }
        if (!this.mPlanar) {
            if (this.mSliceHeight == this.mHeight && this.mStride == this.mWidth) {
                if (!this.mPanesReversed) {
                    for (int i = this.mSize; i < this.mSize + this.mSize / 2; i += 2) {
                        this.mBuffer[0] = byArray[i + 1];
                        byArray[i + 1] = byArray[i];
                        byArray[i] = this.mBuffer[0];
                    }
                }
                if (this.mYPadding > 0) {
                    System.arraycopy(byArray, 0, this.mBuffer, 0, this.mSize);
                    System.arraycopy(byArray, this.mSize, this.mBuffer, this.mSize + this.mYPadding, this.mSize / 2);
                    return this.mBuffer;
                }
                return byArray;
            }
        } else if (this.mSliceHeight == this.mHeight && this.mStride == this.mWidth) {
            if (!this.mPanesReversed) {
                for (int i = 0; i < this.mSize / 4; ++i) {
                    this.mBuffer[i] = byArray[this.mSize + 2 * i + 1];
                    this.mBuffer[this.mSize / 4 + i] = byArray[this.mSize + 2 * i];
                }
            } else {
                for (int i = 0; i < this.mSize / 4; ++i) {
                    this.mBuffer[i] = byArray[this.mSize + 2 * i];
                    this.mBuffer[this.mSize / 4 + i] = byArray[this.mSize + 2 * i + 1];
                }
            }
            if (this.mYPadding != 0) {
                System.arraycopy(byArray, 0, this.mBuffer, 0, this.mSize);
                System.arraycopy(this.mBuffer, 0, this.mBuffer, this.mSize + this.mYPadding, this.mSize / 2);
                return this.mBuffer;
            }
            System.arraycopy(this.mBuffer, 0, byArray, this.mSize, this.mSize / 2);
            return byArray;
        }
        return byArray;
    }
}

