/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.baseutil.hw;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Build;
import android.preference.PreferenceManager;
import android.util.Base64;
import android.util.Log;
import com.immomo.baseutil.hw.CodecManager;
import com.immomo.baseutil.hw.NV21Convertor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;

@SuppressLint(value={"NewApi"})
public class EncoderDebugger {
    public static final String TAG = "EncoderDebugger";
    private static final String PREF_PREFIX = "libstreaming-";
    private static final boolean DEBUG = false;
    private static final boolean VERBOSE = true;
    private static final int VERSION = 3;
    private static final int BITRATE = 1000000;
    private static final int FRAMERATE = 20;
    private static final String MIME_TYPE = "video/avc";
    private static final int NB_DECODED = 34;
    private static final int NB_ENCODED = 50;
    private int mDecoderColorFormat;
    private int mEncoderColorFormat;
    private String mDecoderName;
    private String mEncoderName;
    private String mErrorLog;
    private MediaCodec mEncoder;
    private MediaCodec mDecoder;
    private int mWidth;
    private int mHeight;
    private int mSize;
    private byte[] mSPS;
    private byte[] mPPS;
    private byte[] mData;
    private byte[] mInitialImage;
    private MediaFormat mDecOutputFormat;
    private NV21Convertor mNV21;
    private SharedPreferences mPreferences;
    private byte[][] mVideo;
    private byte[][] mDecodedVideo;
    private String mB64PPS;
    private String mB64SPS;

    private EncoderDebugger(SharedPreferences sharedPreferences, int n, int n2) {
        this.mPreferences = sharedPreferences;
        this.mWidth = n;
        this.mHeight = n2;
        this.mSize = n * n2;
        this.reset();
    }

    public static synchronized void asyncDebug(final Context context, final int n, final int n2) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
                    EncoderDebugger.debug(sharedPreferences, n, n2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, "live-media-EncoderDebugger").start();
    }

    public static synchronized EncoderDebugger debug(Context context, int n, int n2) {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        return EncoderDebugger.debug(sharedPreferences, n, n2);
    }

    public static synchronized EncoderDebugger debug(SharedPreferences sharedPreferences, int n, int n2) {
        EncoderDebugger encoderDebugger = new EncoderDebugger(sharedPreferences, n, n2);
        encoderDebugger.debug();
        return encoderDebugger;
    }

    public static MediaCodecInfo selectCodec(String string) {
        int n = MediaCodecList.getCodecCount();
        for (int i = 0; i < n; ++i) {
            MediaCodecInfo mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i);
            if (!mediaCodecInfo.isEncoder()) continue;
            String[] stringArray = mediaCodecInfo.getSupportedTypes();
            for (int j = 0; j < stringArray.length; ++j) {
                if (!stringArray[j].equalsIgnoreCase(string)) continue;
                return mediaCodecInfo;
            }
        }
        return null;
    }

    public static boolean isCodecSupportedTypes(boolean bl, String string) {
        int n = MediaCodecList.getCodecCount();
        for (int i = 0; i < n; ++i) {
            MediaCodecInfo mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i);
            if (bl != mediaCodecInfo.isEncoder()) continue;
            String[] stringArray = mediaCodecInfo.getSupportedTypes();
            for (int j = 0; j < stringArray.length; ++j) {
                if (!stringArray[j].equalsIgnoreCase(string)) continue;
                return true;
            }
        }
        return false;
    }

    public String getB64PPS() {
        return this.mB64PPS;
    }

    public String getB64SPS() {
        return this.mB64SPS;
    }

    public String getEncoderName() {
        return this.mEncoderName;
    }

    public int getEncoderColorFormat() {
        return this.mEncoderColorFormat;
    }

    public NV21Convertor getNV21Convertor() {
        return this.mNV21;
    }

    public String getErrorLog() {
        return this.mErrorLog;
    }

    private void reset() {
        this.mNV21 = new NV21Convertor();
        this.mVideo = new byte[50][];
        this.mDecodedVideo = new byte[34][];
        this.mErrorLog = "";
        this.mPPS = null;
        this.mSPS = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void debug() {
        int n;
        if (!this.checkTestNeeded()) {
            String string = this.mWidth + "x" + this.mHeight + "-";
            boolean bl = this.mPreferences.getBoolean(PREF_PREFIX + string + "success", false);
            if (!bl) {
                throw new RuntimeException("Phone not supported with this resolution (" + this.mWidth + "x" + this.mHeight + ")");
            }
            this.mNV21.setSize(this.mWidth, this.mHeight);
            this.mNV21.setSliceHeigth(this.mPreferences.getInt(PREF_PREFIX + string + "sliceHeight", 0));
            this.mNV21.setStride(this.mPreferences.getInt(PREF_PREFIX + string + "stride", 0));
            this.mNV21.setYPadding(this.mPreferences.getInt(PREF_PREFIX + string + "padding", 0));
            this.mNV21.setPlanar(this.mPreferences.getBoolean(PREF_PREFIX + string + "planar", false));
            this.mNV21.setColorPanesReversed(this.mPreferences.getBoolean(PREF_PREFIX + string + "reversed", false));
            this.mEncoderName = this.mPreferences.getString(PREF_PREFIX + string + "encoderName", "");
            this.mEncoderColorFormat = this.mPreferences.getInt(PREF_PREFIX + string + "colorFormat", 0);
            this.mB64PPS = this.mPreferences.getString(PREF_PREFIX + string + "pps", "");
            this.mB64SPS = this.mPreferences.getString(PREF_PREFIX + string + "sps", "");
            return;
        }
        Log.d((String)TAG, (String)(">>>> Testing the phone for resolution " + this.mWidth + "x" + this.mHeight));
        CodecManager.Codec[] codecArray = CodecManager.findEncodersForMimeType(MIME_TYPE);
        CodecManager.Codec[] codecArray2 = CodecManager.findDecodersForMimeType(MIME_TYPE);
        int n2 = 0;
        int n3 = 1;
        for (n = 0; n < codecArray.length; ++n) {
            n2 += codecArray[n].formats.length;
        }
        Log.e((String)TAG, (String)("encoders.length" + codecArray.length));
        for (n = 0; n < codecArray.length; ++n) {
            for (int i = 0; i < codecArray[n].formats.length; ++i) {
                this.reset();
                this.mEncoderName = codecArray[n].name;
                this.mEncoderColorFormat = codecArray[n].formats[i];
                Log.e((String)TAG, (String)(">> Test " + n3++ + "/" + n2 + ": " + this.mEncoderName + " with color format " + this.mEncoderColorFormat + " at " + this.mWidth + "x" + this.mHeight));
                this.mNV21.setSize(this.mWidth, this.mHeight);
                this.mNV21.setSliceHeigth(this.mHeight);
                this.mNV21.setStride(this.mWidth);
                this.mNV21.setYPadding(0);
                this.mNV21.setEncoderColorFormat(this.mEncoderColorFormat);
                this.createTestImage();
                this.mData = this.mNV21.convert(this.mInitialImage);
                try {
                    int n4;
                    this.configureEncoder();
                    this.searchSPSandPPS();
                    Log.e((String)TAG, (String)("SPS and PPS in b64: SPS=" + this.mB64SPS + ", PPS=" + this.mB64PPS));
                    this.encode();
                    boolean bl = false;
                    block15: for (n4 = 0; n4 < codecArray2.length && !bl; ++n4) {
                        for (int j = 0; j < codecArray2[n4].formats.length && !bl; ++j) {
                            this.mDecoderName = codecArray2[n4].name;
                            this.mDecoderColorFormat = codecArray2[n4].formats[j];
                            try {
                                this.configureDecoder();
                            }
                            catch (Exception exception) {
                                Log.d((String)TAG, (String)(this.mDecoderName + " can't be used with " + this.mDecoderColorFormat + " at " + this.mWidth + "x" + this.mHeight));
                                this.releaseDecoder();
                                continue block15;
                            }
                            try {
                                this.decode(true);
                                Log.d((String)TAG, (String)(this.mDecoderName + " successfully decoded the NALs (color format " + this.mDecoderColorFormat + ")"));
                                bl = true;
                                continue;
                            }
                            catch (Exception exception) {
                                Log.e((String)TAG, (String)(this.mDecoderName + " failed to decode the NALs"));
                                exception.printStackTrace();
                                continue;
                            }
                            finally {
                                this.releaseDecoder();
                            }
                        }
                    }
                    if (!this.compareLumaPanes()) {
                        // empty if block
                    }
                    if ((n4 = this.checkPaddingNeeded()) > 0) {
                        if (n4 < 4096) {
                            Log.d((String)TAG, (String)("Some padding is needed: " + n4));
                            this.mNV21.setYPadding(n4);
                            this.createTestImage();
                            this.mData = this.mNV21.convert(this.mInitialImage);
                            this.encodeDecode();
                        } else {
                            throw new RuntimeException("It is likely that sliceHeight!=height");
                        }
                    }
                    this.createTestImage();
                    if (!this.compareChromaPanes(false)) {
                        if (this.compareChromaPanes(true)) {
                            this.mNV21.setColorPanesReversed(true);
                            Log.d((String)TAG, (String)"U and V pane are reversed");
                        } else {
                            this.mNV21.setColorPanesReversed(false);
                        }
                    }
                    this.saveTestResult(true);
                    Log.v((String)TAG, (String)("The encoder " + this.mEncoderName + " is usable with resolution " + this.mWidth + "x" + this.mHeight));
                    return;
                }
                catch (Exception exception) {
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    exception.printStackTrace(printWriter);
                    String string = stringWriter.toString();
                    String string2 = "Encoder " + this.mEncoderName + " cannot be used with color format " + this.mEncoderColorFormat;
                    Log.e((String)TAG, (String)string2, (Throwable)exception);
                    this.mErrorLog = this.mErrorLog + string2 + "\n" + string;
                    exception.printStackTrace();
                    continue;
                }
                finally {
                    this.releaseEncoder();
                }
            }
        }
        this.saveTestResult(false);
        Log.e((String)TAG, (String)("No usable encoder were found on the phone for resolution " + this.mWidth + "x" + this.mHeight));
        throw new RuntimeException("No usable encoder were found on the phone for resolution " + this.mWidth + "x" + this.mHeight);
    }

    private boolean checkTestNeeded() {
        String string = this.mWidth + "x" + this.mHeight + "-";
        if (this.mPreferences == null) {
            return true;
        }
        if (this.mPreferences.contains(PREF_PREFIX + string + "lastSdk")) {
            int n = this.mPreferences.getInt(PREF_PREFIX + string + "lastSdk", 0);
            int n2 = this.mPreferences.getInt(PREF_PREFIX + string + "lastVersion", 0);
            return Build.VERSION.SDK_INT > n || 3 > n2;
        }
        return true;
    }

    private void saveTestResult(boolean bl) {
        String string = this.mWidth + "x" + this.mHeight + "-";
        SharedPreferences.Editor editor = this.mPreferences.edit();
        editor.putBoolean(PREF_PREFIX + string + "success", bl);
        if (bl) {
            editor.putInt(PREF_PREFIX + string + "lastSdk", Build.VERSION.SDK_INT);
            editor.putInt(PREF_PREFIX + string + "lastVersion", 3);
            editor.putInt(PREF_PREFIX + string + "sliceHeight", this.mNV21.getSliceHeigth());
            editor.putInt(PREF_PREFIX + string + "stride", this.mNV21.getStride());
            editor.putInt(PREF_PREFIX + string + "padding", this.mNV21.getYPadding());
            editor.putBoolean(PREF_PREFIX + string + "planar", this.mNV21.getPlanar());
            editor.putBoolean(PREF_PREFIX + string + "reversed", this.mNV21.getUVPanesReversed());
            editor.putString(PREF_PREFIX + string + "encoderName", this.mEncoderName);
            editor.putInt(PREF_PREFIX + string + "colorFormat", this.mEncoderColorFormat);
            editor.putString(PREF_PREFIX + string + "encoderName", this.mEncoderName);
            editor.putString(PREF_PREFIX + string + "pps", this.mB64PPS);
            editor.putString(PREF_PREFIX + string + "sps", this.mB64SPS);
        }
        editor.commit();
    }

    private void createTestImage() {
        int n;
        this.mInitialImage = new byte[3 * this.mSize / 2];
        for (n = 0; n < this.mSize; ++n) {
            this.mInitialImage[n] = (byte)(40 + n % 199);
        }
        for (n = this.mSize; n < 3 * this.mSize / 2; n += 2) {
            this.mInitialImage[n] = (byte)(40 + n % 200);
            this.mInitialImage[n + 1] = (byte)(40 + (n + 99) % 200);
        }
    }

    private boolean compareLumaPanes() {
        return true;
    }

    private int checkPaddingNeeded() {
        int n = 0;
        int n2 = 3 * this.mSize / 2 - 1;
        int n3 = 0;
        int[] nArray = new int[34];
        for (int i = 0; i < 34; ++i) {
            if (this.mDecodedVideo[i] == null) continue;
            for (n = 0; n < n2 && (this.mDecodedVideo[i][n2 - n] & 0xFF) < 50; n += 2) {
            }
            if (n > 0) {
                nArray[i] = n >> 6 << 6;
                n3 = nArray[i] > n3 ? nArray[i] : n3;
                Log.e((String)TAG, (String)("Padding needed: " + nArray[i]));
                continue;
            }
            Log.v((String)TAG, (String)"No padding needed.");
        }
        return n3 >> 6 << 6;
    }

    private boolean compareChromaPanes(boolean bl) {
        return true;
    }

    private void convertToNV21(int n) {
        int n2;
        MediaFormat mediaFormat;
        byte[] byArray = new byte[3 * this.mSize / 2];
        int n3 = this.mWidth;
        int n4 = this.mHeight;
        int n5 = this.mDecoderColorFormat;
        boolean bl = false;
        if (this.mDecOutputFormat != null && (mediaFormat = this.mDecOutputFormat) != null) {
            if (mediaFormat.containsKey("slice-height") && (n4 = mediaFormat.getInteger("slice-height")) < this.mHeight) {
                n4 = this.mHeight;
            }
            if (mediaFormat.containsKey("stride") && (n3 = mediaFormat.getInteger("stride")) < this.mWidth) {
                n3 = this.mWidth;
            }
            if (mediaFormat.containsKey("color-format") && mediaFormat.getInteger("color-format") > 0) {
                n5 = mediaFormat.getInteger("color-format");
            }
        }
        switch (n5) {
            case 21: 
            case 39: 
            case 2130706688: 
            case 2141391872: {
                bl = false;
                break;
            }
            case 19: 
            case 20: {
                bl = true;
                break;
            }
            default: {
                bl = true;
            }
        }
        for (n2 = 0; n2 < this.mSize; ++n2) {
            if (n2 % this.mWidth == 0) {
                n2 += n3 - this.mWidth;
            }
            byArray[n2] = this.mDecodedVideo[n][n2];
        }
        if (!bl) {
            n2 = 0;
            for (int i = 0; i < this.mSize / 4; ++i) {
                if (n2 % this.mWidth / 2 == 0) {
                    n2 += (n3 - this.mWidth) / 2;
                }
                byArray[this.mSize + 2 * i + 1] = this.mDecodedVideo[n][n3 * n4 + 2 * n2];
                byArray[this.mSize + 2 * i] = this.mDecodedVideo[n][n3 * n4 + 2 * n2 + 1];
                ++n2;
            }
        } else {
            n2 = 0;
            for (int i = 0; i < this.mSize / 4; ++i) {
                if (n2 % this.mWidth / 2 == 0) {
                    n2 += (n3 - this.mWidth) / 2;
                }
                byArray[this.mSize + 2 * i + 1] = this.mDecodedVideo[n][n3 * n4 + n2];
                byArray[this.mSize + 2 * i] = this.mDecodedVideo[n][n3 * n4 * 5 / 4 + n2];
                ++n2;
            }
        }
        this.mDecodedVideo[n] = byArray;
    }

    private void configureEncoder() {
        try {
            this.mEncoder = MediaCodec.createByCodecName((String)this.mEncoderName);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)MIME_TYPE, (int)this.mWidth, (int)this.mHeight);
        mediaFormat.setInteger("bitrate", 1000000);
        mediaFormat.setInteger("frame-rate", 20);
        mediaFormat.setInteger("color-format", this.mEncoderColorFormat);
        mediaFormat.setInteger("i-frame-interval", 1);
        this.mEncoder.configure(mediaFormat, null, null, 1);
        this.mEncoder.start();
    }

    private void releaseEncoder() {
        if (this.mEncoder != null) {
            try {
                this.mEncoder.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.mEncoder.release();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void configureDecoder() {
        byte[] byArray = new byte[]{0, 0, 0, 1};
        ByteBuffer byteBuffer = ByteBuffer.allocate(4 + this.mSPS.length + 4 + this.mPPS.length);
        byteBuffer.put(new byte[]{0, 0, 0, 1});
        byteBuffer.put(this.mSPS);
        byteBuffer.put(new byte[]{0, 0, 0, 1});
        byteBuffer.put(this.mPPS);
        try {
            this.mDecoder = MediaCodec.createByCodecName((String)this.mDecoderName);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)MIME_TYPE, (int)this.mWidth, (int)this.mHeight);
        mediaFormat.setByteBuffer("csd-0", byteBuffer);
        mediaFormat.setInteger("color-format", this.mDecoderColorFormat);
        this.mDecoder.configure(mediaFormat, null, null, 0);
        this.mDecoder.start();
        ByteBuffer[] byteBufferArray = this.mDecoder.getInputBuffers();
        int n = this.mDecoder.dequeueInputBuffer(50000L);
        if (n >= 0) {
            byteBufferArray[n].clear();
            byteBufferArray[n].put(byArray);
            byteBufferArray[n].put(this.mSPS);
            this.mDecoder.queueInputBuffer(n, 0, byteBufferArray[n].position(), this.timestamp(), 0);
        } else {
            Log.e((String)TAG, (String)"No buffer available !");
        }
        n = this.mDecoder.dequeueInputBuffer(50000L);
        if (n >= 0) {
            byteBufferArray[n].clear();
            byteBufferArray[n].put(byArray);
            byteBufferArray[n].put(this.mPPS);
            this.mDecoder.queueInputBuffer(n, 0, byteBufferArray[n].position(), this.timestamp(), 0);
        } else {
            Log.e((String)TAG, (String)"No buffer available !");
        }
    }

    private void releaseDecoder() {
        if (this.mDecoder != null) {
            try {
                this.mDecoder.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.mDecoder.release();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private long searchSPSandPPS() {
        ByteBuffer[] byteBufferArray = this.mEncoder.getInputBuffers();
        ByteBuffer[] byteBufferArray2 = this.mEncoder.getOutputBuffers();
        MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
        byte[] byArray = new byte[128];
        int n = 0;
        int n2 = 4;
        int n3 = 4;
        long l = 0L;
        long l2 = this.timestamp();
        while (l < 3000000L && (this.mSPS == null || this.mPPS == null)) {
            int n4 = this.mEncoder.dequeueInputBuffer(50000L);
            if (n4 >= 0) {
                this.check(byteBufferArray[n4].capacity() >= this.mData.length, "The input buffer is not big enough.");
                byteBufferArray[n4].clear();
                byteBufferArray[n4].put(this.mData, 0, this.mData.length);
                this.mEncoder.queueInputBuffer(n4, 0, this.mData.length, this.timestamp(), 0);
            } else {
                Log.e((String)TAG, (String)"No buffer available !");
            }
            int n5 = this.mEncoder.dequeueOutputBuffer(bufferInfo, 50000L);
            if (n5 == -2) {
                MediaFormat mediaFormat = this.mEncoder.getOutputFormat();
                ByteBuffer byteBuffer = mediaFormat.getByteBuffer("csd-0");
                ByteBuffer byteBuffer2 = mediaFormat.getByteBuffer("csd-1");
                this.mSPS = new byte[byteBuffer.capacity() - 4];
                byteBuffer.position(4);
                byteBuffer.get(this.mSPS, 0, this.mSPS.length);
                this.mPPS = new byte[byteBuffer2.capacity() - 4];
                byteBuffer2.position(4);
                byteBuffer2.get(this.mPPS, 0, this.mPPS.length);
                break;
            }
            if (n5 == -3) {
                byteBufferArray2 = this.mEncoder.getOutputBuffers();
            } else if (n5 >= 0) {
                n = bufferInfo.size;
                if (n < 128) {
                    byteBufferArray2[n5].get(byArray, 0, n);
                    if (n > 0 && byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 1) {
                        while (n2 < n) {
                            while ((byArray[n2 + 0] != 0 || byArray[n2 + 1] != 0 || byArray[n2 + 2] != 0 || byArray[n2 + 3] != 1) && n2 + 3 < n) {
                                ++n2;
                            }
                            if (n2 + 3 >= n) {
                                n2 = n;
                            }
                            if ((byArray[n3] & 0x1F) == 7) {
                                this.mSPS = new byte[n2 - n3];
                                System.arraycopy(byArray, n3, this.mSPS, 0, n2 - n3);
                            } else {
                                this.mPPS = new byte[n2 - n3];
                                System.arraycopy(byArray, n3, this.mPPS, 0, n2 - n3);
                            }
                            n3 = n2 += 4;
                        }
                    }
                }
                this.mEncoder.releaseOutputBuffer(n5, false);
            }
            l = this.timestamp() - l2;
        }
        this.check(this.mPPS != null & this.mSPS != null, "Could not determine the SPS & PPS.");
        this.mB64PPS = Base64.encodeToString((byte[])this.mPPS, (int)0, (int)this.mPPS.length, (int)2);
        this.mB64SPS = Base64.encodeToString((byte[])this.mSPS, (int)0, (int)this.mSPS.length, (int)2);
        return l;
    }

    private long encode() {
        int n = 0;
        long l = 0L;
        long l2 = this.timestamp();
        int n2 = 0;
        int n3 = 0;
        MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
        ByteBuffer[] byteBufferArray = this.mEncoder.getInputBuffers();
        ByteBuffer[] byteBufferArray2 = this.mEncoder.getOutputBuffers();
        while (l < 5000000L) {
            n3 = this.mEncoder.dequeueInputBuffer(50000L);
            if (n3 >= 0) {
                this.check(byteBufferArray[n3].capacity() >= this.mData.length, "The input buffer is not big enough.");
                byteBufferArray[n3].clear();
                byteBufferArray[n3].put(this.mData, 0, this.mData.length);
                this.mEncoder.queueInputBuffer(n3, 0, this.mData.length, this.timestamp(), 0);
            } else {
                Log.d((String)TAG, (String)"No buffer available !");
            }
            n2 = this.mEncoder.dequeueOutputBuffer(bufferInfo, 50000L);
            if (n2 == -3) {
                byteBufferArray2 = this.mEncoder.getOutputBuffers();
            } else if (n2 >= 0) {
                this.mVideo[n] = new byte[bufferInfo.size];
                byteBufferArray2[n2].clear();
                byteBufferArray2[n2].get(this.mVideo[n++], 0, bufferInfo.size);
                this.mEncoder.releaseOutputBuffer(n2, false);
                if (n >= 50) {
                    this.flushMediaCodec(this.mEncoder);
                    return l;
                }
            }
            l = this.timestamp() - l2;
        }
        throw new RuntimeException("The encoder is too slow.");
    }

    private long decode(boolean bl) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        long l = 0L;
        long l2 = this.timestamp();
        int n4 = 0;
        int n5 = 0;
        ByteBuffer[] byteBufferArray = this.mDecoder.getInputBuffers();
        ByteBuffer[] byteBufferArray2 = this.mDecoder.getOutputBuffers();
        MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
        while (l < 3000000L) {
            int n6;
            if (n2 < 50) {
                n4 = this.mDecoder.dequeueInputBuffer(50000L);
                if (n4 >= 0) {
                    n6 = byteBufferArray[n4].capacity();
                    int n7 = this.mVideo[n2].length;
                    byteBufferArray[n4].clear();
                    if (bl && this.hasPrefix(this.mVideo[n2]) || !bl && !this.hasPrefix(this.mVideo[n2])) {
                        this.check(n6 >= n7, "The decoder input buffer is not big enough (nal=" + n7 + ", capacity=" + n6 + ").");
                        byteBufferArray[n4].put(this.mVideo[n2], 0, this.mVideo[n2].length);
                    } else if (bl && !this.hasPrefix(this.mVideo[n2])) {
                        this.check(n6 >= n7 + 4, "The decoder input buffer is not big enough (nal=" + (n7 + 4) + ", capacity=" + n6 + ").");
                        byteBufferArray[n4].put(new byte[]{0, 0, 0, 1});
                        byteBufferArray[n4].put(this.mVideo[n2], 0, this.mVideo[n2].length);
                    } else if (!bl && this.hasPrefix(this.mVideo[n2])) {
                        this.check(n6 >= n7 - 4, "The decoder input buffer is not big enough (nal=" + (n7 - 4) + ", capacity=" + n6 + ").");
                        byteBufferArray[n4].put(this.mVideo[n2], 4, this.mVideo[n2].length - 4);
                    }
                    this.mDecoder.queueInputBuffer(n4, 0, n7, this.timestamp(), 0);
                    ++n2;
                } else {
                    Log.d((String)TAG, (String)"No buffer available !");
                }
            }
            if ((n5 = this.mDecoder.dequeueOutputBuffer(bufferInfo, 50000L)) == -3) {
                byteBufferArray2 = this.mDecoder.getOutputBuffers();
            } else if (n5 == -2) {
                this.mDecOutputFormat = this.mDecoder.getOutputFormat();
            } else if (n5 >= 0) {
                if (n > 2) {
                    n6 = bufferInfo.size;
                    this.mDecodedVideo[n3] = new byte[n6];
                    byteBufferArray2[n5].clear();
                    byteBufferArray2[n5].get(this.mDecodedVideo[n3], 0, n6);
                    this.convertToNV21(n3);
                    if (n3 >= 33) {
                        this.flushMediaCodec(this.mDecoder);
                        Log.v((String)TAG, (String)("Decoding " + n + " frames took " + l / 1000L + " ms"));
                        return l;
                    }
                    ++n3;
                }
                this.mDecoder.releaseOutputBuffer(n5, false);
                ++n;
            }
            l = this.timestamp() - l2;
        }
        throw new RuntimeException("The decoder did not decode anything.");
    }

    private boolean hasPrefix(byte[] byArray) {
        return byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 1;
    }

    private void encodeDecode() {
        this.encode();
        try {
            this.configureDecoder();
        }
        finally {
            this.releaseDecoder();
        }
    }

    private void flushMediaCodec(MediaCodec mediaCodec) {
        int n = 0;
        MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
        while (n != -1) {
            n = mediaCodec.dequeueOutputBuffer(bufferInfo, 50000L);
            if (n < 0) continue;
            mediaCodec.releaseOutputBuffer(n, false);
        }
    }

    private void check(boolean bl, String string) {
        if (!bl) {
            Log.e((String)TAG, (String)string);
            throw new IllegalStateException(string);
        }
    }

    private long timestamp() {
        return System.nanoTime() / 1000L;
    }
}

