/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.baseutil.hw;

import android.annotation.SuppressLint;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.util.Log;
import com.immomo.baseutil.DebugLog;
import java.util.ArrayList;
import java.util.HashSet;

@SuppressLint(value={"InlinedApi"})
public class CodecManager {
    public static final String TAG = "CodecManager";
    public static final int[] SUPPORTED_COLOR_FORMATS = new int[]{21, 39, 19, 20, 2130706688, 2141391872};
    private static Codec[] sEncoders = null;
    private static Codec[] sDecoders = null;

    private static MediaCodecInfo selectCodec(String string) {
        int n = MediaCodecList.getCodecCount();
        for (int i = 0; i < n; ++i) {
            MediaCodecInfo mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i);
            if (!mediaCodecInfo.isEncoder()) continue;
            String[] stringArray = mediaCodecInfo.getSupportedTypes();
            for (int j = 0; j < stringArray.length; ++j) {
                if (!stringArray[j].equalsIgnoreCase(string)) continue;
                return mediaCodecInfo;
            }
        }
        return null;
    }

    private static int findNonSurfaceColorFormat(MediaCodecInfo mediaCodecInfo, String string) {
        MediaCodecInfo.CodecCapabilities codecCapabilities = mediaCodecInfo.getCapabilitiesForType(string);
        for (int i = 0; i < codecCapabilities.colorFormats.length; ++i) {
            int n = codecCapabilities.colorFormats[i];
            if (n == 2130708361) continue;
            DebugLog.e(TAG, "findNonSurfaceColorFormat:" + n);
            return n;
        }
        return 0;
    }

    @SuppressLint(value={"NewApi"})
    public static synchronized Codec[] findEncodersForMimeType(String string) {
        if (sEncoders != null) {
            return sEncoders;
        }
        ArrayList<Codec> arrayList = new ArrayList<Codec>();
        for (int i = MediaCodecList.getCodecCount() - 1; i >= 0; --i) {
            MediaCodecInfo mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i);
            if (!mediaCodecInfo.isEncoder()) continue;
            String[] stringArray = mediaCodecInfo.getSupportedTypes();
            for (int j = 0; j < stringArray.length; ++j) {
                if (!stringArray[j].equalsIgnoreCase(string)) continue;
                try {
                    MediaCodecInfo.CodecCapabilities codecCapabilities = mediaCodecInfo.getCapabilitiesForType(string);
                    HashSet<Integer> hashSet = new HashSet<Integer>();
                    for (int k = 0; k < codecCapabilities.colorFormats.length; ++k) {
                        int n = codecCapabilities.colorFormats[k];
                        for (int i2 = 0; i2 < SUPPORTED_COLOR_FORMATS.length; ++i2) {
                            if (n != SUPPORTED_COLOR_FORMATS[i2]) continue;
                            hashSet.add(n);
                        }
                    }
                    Codec codec = new Codec(mediaCodecInfo.getName(), hashSet.toArray(new Integer[hashSet.size()]));
                    arrayList.add(codec);
                    continue;
                }
                catch (Exception exception) {
                    Log.wtf((String)TAG, (Throwable)exception);
                }
            }
        }
        sEncoders = arrayList.toArray(new Codec[arrayList.size()]);
        return sEncoders;
    }

    @SuppressLint(value={"NewApi"})
    public static synchronized Codec[] findDecodersForMimeType(String string) {
        Object object;
        int n;
        if (sDecoders != null) {
            return sDecoders;
        }
        ArrayList<Codec> arrayList = new ArrayList<Codec>();
        for (n = MediaCodecList.getCodecCount() - 1; n >= 0; --n) {
            object = MediaCodecList.getCodecInfoAt((int)n);
            if (object.isEncoder()) continue;
            String[] stringArray = object.getSupportedTypes();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equalsIgnoreCase(string)) continue;
                try {
                    MediaCodecInfo.CodecCapabilities codecCapabilities = object.getCapabilitiesForType(string);
                    HashSet<Integer> hashSet = new HashSet<Integer>();
                    for (int j = 0; j < codecCapabilities.colorFormats.length; ++j) {
                        int n2 = codecCapabilities.colorFormats[j];
                        for (int k = 0; k < SUPPORTED_COLOR_FORMATS.length; ++k) {
                            if (n2 != SUPPORTED_COLOR_FORMATS[k]) continue;
                            hashSet.add(n2);
                        }
                    }
                    Codec codec = new Codec(object.getName(), hashSet.toArray(new Integer[hashSet.size()]));
                    arrayList.add(codec);
                    continue;
                }
                catch (Exception exception) {
                    Log.wtf((String)TAG, (Throwable)exception);
                }
            }
        }
        sDecoders = arrayList.toArray(new Codec[arrayList.size()]);
        for (n = 0; n < sDecoders.length; ++n) {
            if (!CodecManager.sDecoders[n].name.equalsIgnoreCase("omx.google.h264.decoder")) continue;
            object = sDecoders[0];
            CodecManager.sDecoders[0] = sDecoders[n];
            CodecManager.sDecoders[n] = object;
        }
        return sDecoders;
    }

    static class Codec {
        public String name;
        public Integer[] formats;

        public Codec(String string, Integer[] integerArray) {
            this.name = string;
            this.formats = integerArray;
        }
    }
}

